/*
 * This file is part of PB-Lib v3.0 C++ Programming Library
 *
 * Copyright (c) 1995, 1997 by Branislav L. Slantchev
 * A fine product of Silicon Creations, Inc. (gargoyle)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the License which accompanies this
 * software. This library is distributed in the hope that it will
 * be useful, but without any warranty; without even the implied
 * warranty of merchantability or fitness for a particular purpose.
 *
 * You should have received a copy of the License along with this
 * library, in the file LICENSE.DOC; if not, write to the address
 * below to receive a copy via electronic mail.
 *
 * You can reach Branislav L. Slantchev (Silicon Creations, Inc.)
 * at bslantch@cs.angelo.edu. The file SUPPORT.DOC has the current
 * telephone numbers and the postal address for contacts.
*/

#ifndef INCLUDED_STR_H
#define INCLUDED_STR_H

/*
 * s t r i n g   m a n i p u l a t i o n   r o u t i n e s
 * 
 * miscellaneous string and character manipulation routines
*/
#include "typedef.h"
#include "stdmac.h"

#ifndef PB_SDK
	#include <string.h>
	#include <stdlib.h>
	#include <time.h>
	#include <ctype.h>
	#include <stdarg.h>
#else
	#include "pblibc.h"
#endif

#define STREQU(a,b)     ( 0 == strcmp(a,b)    )
#define STRNEQU(a,b)    ( 0 != strcmp(a,b)    )
#define STRIEQU(a,b)    ( 0 == stricmp(a,b)   )
#define STRINEQU(a,b)   ( 0 != stricmp(a,b)   )
#define MEMEQU(a,b,l)   ( 0 == memcmp(a,b,l)  )
#define MEMNEQU(a,b,l)  ( 0 != memcmp(a,b,l)  )
#define MEMIEQU(a,b,l)  ( 0 == memicmp(a,b,l) )
#define MEMINEQU(a,b,l) ( 0 != memicmp(a,b,l) )

char *strichr( const char *s, int ch );
char *stristr( const char *s1, const char *s2 );
char *strecpy( char *dest, const char *src );
char *strnecpy( char *dest, const char *src, size_t n );
char *strdel( char *s, size_t index, size_t n );
char *strins( char *s1, const char *s2, size_t index );
char *strtrm( char *s );
char *strrtrm( char *s );
char *strcma( char *dest, const char *src );
char *strtime( void );
char *strdate( void );
char *strcins( char *s, size_t index, int ch );
char *strcdel( char *s, size_t index );
char *strccat( char *s, int ch );
char *strtts( const char *s, int n );
char *strleft( char *dest, const char *src, size_t n );
char *stright( char *dest, const char *src, size_t n );
char *strmid( char *dest, const char *src, size_t index, size_t n );
char *strvcat( char *s, ... );
char *strcent( char *dest, const char *src, size_t n );
char *strneset( char *s, int ch, size_t n );
char *strfupr( char *s, const char *sep );
char *strcrm( char *s, int c );
char *strcrep( char *s, int c1, int c2 );
char *strsrm( char *s1, const char *s2 );
char *strsrep( char *s1, const char *s2, const char *s3 );
char *stradd( char *dest, const char *s1, const char *s2 );
char *strskpw( char *s );
char *strskpnw( char *s );

#endif /* INCLUDED_STR_H */
