/*
 * This file is part of PB-Lib v3.0 C++ Programming Library
 *
 * Copyright (c) 1995, 1997 by Branislav L. Slantchev
 * A fine product of Silicon Creations, Inc. (gargoyle)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the License which accompanies this
 * software. This library is distributed in the hope that it will
 * be useful, but without any warranty; without even the implied
 * warranty of merchantability or fitness for a particular purpose.
 *
 * You should have received a copy of the License along with this
 * library, in the file LICENSE.DOC; if not, write to the address
 * below to receive a copy via electronic mail.
 *
 * You can reach Branislav L. Slantchev (Silicon Creations, Inc.)
 * at bslantch@cs.angelo.edu. The file SUPPORT.DOC has the current
 * telephone numbers and the postal address for contacts.
*/

#ifndef INCLUDED_STDMAC_H
#define INCLUDED_STDMAC_H

#ifndef TRUE
	#define FALSE            (0)           //..............boolean true value
	#define TRUE             (1)           //.............boolean false value
#endif

#ifndef MAXPATH
	#define MAXPATH          80            //........max drive+path+name spec
	#define MAXDRIVE         3             //.........max drive specification
	#define MAXDIR           66            //..............max directory only
	#define MAXFILE          9             //...............max filename spec
	#define MAXEXT           5             //..........max extension with dot
#endif

#define EOS              '\0'          //..ASCII end-of-string nul terminator
#define BOOLEAN(x)       ( !(!(x)) )   //...always 1 or 0 regardless of value
#define BUFSIZE          1024          //.................generic buffer size
#define CAST(a,type)     ( *((type far *)&(a)) )    //........cast any object
#define HIBYTE(w)        ( ((w) >> 8) & 0x00ff )    //..........get high byte
#define LOBYTE(w)        ( (w) & 0x00ff )           //.......get the low byte
#define LAST_CHAR(s)     ((char*)s)[strlen(s) - 1]  //...get ptr to last char
#define PLURAL_TEXT(n)   &"s"[(1 == n) ? 1 : 0]     //....add 's' for plurals

#endif /* INCLUDED_STDMAC_H */
