/*
 * This file is part of PB-Lib v3.0 C++ Programming Library
 *
 * Copyright (c) 1995, 1997 by Branislav L. Slantchev
 * A fine product of Silicon Creations, Inc. (gargoyle)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the License which accompanies this
 * software. This library is distributed in the hope that it will
 * be useful, but without any warranty; without even the implied
 * warranty of merchantability or fitness for a particular purpose.
 *
 * You should have received a copy of the License along with this
 * library, in the file LICENSE.DOC; if not, write to the address
 * below to receive a copy via electronic mail.
 *
 * You can reach Branislav L. Slantchev (Silicon Creations, Inc.)
 * at bslantch@cs.angelo.edu. The file SUPPORT.DOC has the current
 * telephone numbers and the postal address for contacts.
*/

#ifndef INCLUDED_SLIST_H
#define INCLUDED_SLIST_H

/*
 * s i n g l y - l i n k e d   l i s t   c l a s s
 * 
 * declarations for the singly-linked list with node structure and iterators
*/
#include "typedef.h"

////////////////////////////////////////////////////////////////////////////
// the list node class
////////////////////////////////////////////////////////////////////////////
class zSLNode
{
	friend class zSingleList;
	friend class zListIterator;
	friend class zSLSortedList;

public:
	zSLNode(void *aData = 0): data(aData){}
private:
	zSLNode *next;
    void    *data;
};

////////////////////////////////////////////////////////////////////////////
// the single list class
////////////////////////////////////////////////////////////////////////////
class zSingleList
{
	friend class zListIterator;

public:
	zSingleList(Boolean shouldDelete = False);
	virtual ~zSingleList();

	ushort  link(void *data);
    ushort  append(void *data);
	ushort  unlink();

	ushort  next();
	ushort  begin();
	ushort  end();

	ushort  operator++(){ return next(); }
	ushort  operator++(int){ return next(); }
	ushort  operator+=(ushort nelem);
	void   *operator()() const { return get(); }

	Boolean atStart() const { return (1L == cpos) ? True : False; }
	Boolean atEnd() const { return (cpos == count) ? True : False; }

	void    forEach(fpAppFunc action, void *arg = 0);
	ushort  firstThat(fpTestFunc test, void *arg = 0);

	ushort  update(void *data);
	void   *get() const { return count ? focus->data : 0; }
	long    size() const { return count; }
	ushort  error(){ ushort e = err; err = 0; return e; }

protected:
	virtual void freeData(void *data) { delete data; }

	Boolean        purge;
	long           count;
	long           cpos;
	zSLNode       *tail;
	zSLNode       *focus;
	ushort         err;
};

////////////////////////////////////////////////////////////////////////////
// the list iterator class
////////////////////////////////////////////////////////////////////////////
class zListIterator
{
public:
	zListIterator(zSingleList &aList, Boolean atStart = True);

    ushort  begin();
    ushort  end();
    ushort  next();

	void    sync();

    ushort  update(void *data);
    void   *get() const;

    ushort  operator++(){ return next(); }
    ushort  operator++(int){ return next(); }
    ushort  operator+=(ushort nelem);
    void   *operator()() const { return get(); }

    Boolean atEnd() const;
    Boolean atStart() const { return (1L == cpos) ? True : False; }

protected:
	zSLNode     *focus;
	long         cpos;
	zSingleList &list;
};

////////////////////////////////////////////////////////////////////////////
// the sorted list class
////////////////////////////////////////////////////////////////////////////
class zSLSortedList: public zSingleList
{
public:
	zSLSortedList(Boolean shouldDelete = False): zSingleList(shouldDelete){}

    ushort link(void *);

protected:
	virtual void *keyOf(void *data) const { return data; }
    virtual int   compare(void *key1, void *key2) const = 0;
};

#endif /* INCLUDED_SLIST_H */
