/*
 * This file is part of PB-Lib v3.0 C++ Programming Library
 *
 * Copyright (c) 1995, 1997 by Branislav L. Slantchev
 * A fine product of Silicon Creations, Inc. (gargoyle)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the License which accompanies this
 * software. This library is distributed in the hope that it will
 * be useful, but without any warranty; without even the implied
 * warranty of merchantability or fitness for a particular purpose.
 *
 * You should have received a copy of the License along with this
 * library, in the file LICENSE.DOC; if not, write to the address
 * below to receive a copy via electronic mail.
 *
 * You can reach Branislav L. Slantchev (Silicon Creations, Inc.)
 * at bslantch@cs.angelo.edu. The file SUPPORT.DOC has the current
 * telephone numbers and the postal address for contacts.
*/

#ifndef INCLUDED_PBUSER_H
#define INCLUDED_PBUSER_H

/*
 * u s e r b a s e   d i r e c t   a c c e s s   c l a s s
 * 
 * low-level class for accessing the userbase in an abstract (proboard) way
*/
#include "typedef.h"
#include "pblsdk.h"

#ifndef PB_SDK
	#include "pbstruct.h"
#endif

class zProUser
{
public:
	zProUser();

	Boolean  Load(long recno);
	Boolean  Save(Boolean backup = True);
	ulong    CalcUserCrc(Boolean alias = False);

	// these two static members can be used by all instances
	// and can be used globally with the scope resolution operator
	// like this - zProUser::Backup() to backup the userbase
	static ushort GetTotal();
	static void   Backup();
	static long   Find(const char *s, Boolean alias = False);

	// this is the structure that can be accessed by non-members too
	USER_REC m_rec;

#ifndef PB_SDK
private:
	void ConvertToRecord();
	void PackUserFlags();
	void UnpackUserFlags();
	void ConvertToFiles();

	USERS    m_ra;
	USERSPB  m_pb;
	USERSIDX m_idx;
#endif
};

#endif /* prouser.h */
