/*
 * This file is part of PB-Lib v3.0 C++ Programming Library
 *
 * Copyright (c) 1995, 1997 by Branislav L. Slantchev
 * A fine product of Silicon Creations, Inc. (gargoyle)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the License which accompanies this
 * software. This library is distributed in the hope that it will
 * be useful, but without any warranty; without even the implied
 * warranty of merchantability or fitness for a particular purpose.
 *
 * You should have received a copy of the License along with this
 * library, in the file LICENSE.DOC; if not, write to the address
 * below to receive a copy via electronic mail.
 *
 * You can reach Branislav L. Slantchev (Silicon Creations, Inc.)
 * at bslantch@cs.angelo.edu. The file SUPPORT.DOC has the current
 * telephone numbers and the postal address for contacts.
*/

#ifndef INCLUDED_PBLANG_H
#define INCLUDED_PBLANG_H

/*
 * p r o b o a r d   l a n g u a g e   f i l e   s u p p o r t
 * 
 * these are the classes which provide direct support for the language files.
*/
#include "pbstruct.h"
#include "slist.h"
#include "stdmac.h"

#ifndef PB_SDK
	#include <stdio.h>
#else
	#include "pblibc.h"
#endif

// each individual prompt entry in the prompt list
class zPrompt
{
public:
	zPrompt(PBL_ITEM &aData, short aNum);
	~zPrompt();

	PBL_ITEM  data;
	short     num;
	char     *text;
	char     *keys;
};

// the prompt list
class zPromptList: public zSingleList
{
public:
	zPromptList(): zSingleList(True){}
	~zPromptList();
};

class zTerminal;  // forward declaration

// the actual language handling class
class zProLang
{
public:
	zProLang(zTerminal * const pTerminal);
	~zProLang();

	Boolean Load(short aNum);
	int     Exec(short aNum, Boolean honorType = True);

	Boolean Error();
	ushort  GetNumPrompts() const;
	ulong	GetFlags() const;
	ushort  GetLevel() const;
	Boolean GetStatus() const;

	const char *GetItemText(short aNum);
	const char *GetItemKeys(short aNum);
	const char *GetName() const;
	const char *GetCopyright() const;
	const char *GetMenuPath() const;
	const char *GetTextPath() const;
	const char *GetQuestPath() const;

protected:
	FILE       *find(short num);
	char       *atCode(char *s);

	Boolean      err;            //.......................internal init error
	Boolean      indexed;        //.........................index file exists
	zPromptList *list;           //..................list of compiled prompts
	zTerminal   *terminal;       //......................the display terminal
	ushort       nPrompts;       //.............number of prompts in the file
	PBL_HEADER   text;           //...............text of the language header
	char         path[MAXPATH];  //.....................full path to the file
	char         index[MAXPATH]; //.......full path to the index file, if any
};

////////////////////////////////////////////////////////////////////////////
// various inlined member functions
////////////////////////////////////////////////////////////////////////////
inline
zPrompt::~zPrompt()
{
	if( text ) delete[] text;
	if( keys ) delete[] keys;
}

// return and reset the error code
inline Boolean
zProLang::Error()
{
	Boolean e = err;
	err = False;
	return e;
}

// return number of prompts in the file
inline ushort
zProLang::GetNumPrompts() const
{
	return text.numItems;
}

// return bitmap access flags for language
inline ulong
zProLang::GetFlags() const
{
	return text.aFlags;
}

// return level required to access language
inline ushort
zProLang::GetLevel() const
{
	return text.level;
}

// is the language available
inline Boolean
zProLang::GetStatus() const
{
	return Boolean(text.avail);
}

// return the description of the language
inline const char*
zProLang::GetName() const
{
	return text.name;
}

// return the copyright string of the language
inline const char*
zProLang::GetCopyright() const
{
	return text.copyright;
}

// return the language menu path
inline const char*
zProLang::GetMenuPath() const
{
	return text.menuPath;
}

// return the language textfile path
inline const char*
zProLang::GetTextPath() const
{
	return text.textPath;
}

// return the language questionnaire path
inline const char*
zProLang::GetQuestPath() const
{
	return text.questPath;
}

#endif /* INCLUDED_PBLANG_H */
