/*
 * This file is part of PB-Lib v3.0 C++ Programming Library
 *
 * Copyright (c) 1995, 1997 by Branislav L. Slantchev
 * A fine product of Silicon Creations, Inc. (gargoyle)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the License which accompanies this
 * software. This library is distributed in the hope that it will
 * be useful, but without any warranty; without even the implied
 * warranty of merchantability or fitness for a particular purpose.
 *
 * You should have received a copy of the License along with this
 * library, in the file LICENSE.DOC; if not, write to the address
 * below to receive a copy via electronic mail.
 *
 * You can reach Branislav L. Slantchev (Silicon Creations, Inc.)
 * at bslantch@cs.angelo.edu. The file SUPPORT.DOC has the current
 * telephone numbers and the postal address for contacts.
*/

#ifndef INCLUDED_PARSEDEF_H
#define INCLUDED_PARSEDEF_H

/////////////////////////////////////////////////////////////////////////////
// parser token codes
/////////////////////////////////////////////////////////////////////////////
#define PDEF_ERROR          0x0001 //.........intermediate error during parse
#define PDEF_DEAD           0x0002 //........token has already been processed
//...........................................................time bank tokens
#define PDEF_TB_KBDIFF      0x0101 //................time bank kbytes balance
#define PDEF_TB_KBGET       0x0102 //..............time bank kbytes withdrawn
#define PDEF_TB_KBLOAN      0x0103 //.................time bank kbytes loaned
#define PDEF_TB_KBPAY       0x0104 //...........time bank kbytes payback date
#define PDEF_TB_KBPUT       0x0105 //..............time bank kbytes deposited
#define PDEF_TB_LAST        0x0106 //................time bank date last used
#define PDEF_TB_TDIFF       0x0107 //..................time bank time balance
#define PDEF_TB_TGET        0x0108 //................time bank time withdrawn
#define PDEF_TB_TLOAN       0x0109 //...................time bank time loaned
#define PDEF_TB_TPAY        0x010A //.............time bank time payback date
#define PDEF_TB_TPUT        0x010B //................time bank time deposited
//.........................................................wide system tokens
#define PDEF_SYS_ACTIVE     0x0201 //...............days the system is active
#define PDEF_SYS_BAUD       0x0202 //.......................current baud rate
#define PDEF_SYS_DATE       0x0203 //..................current date DD MMM YY
#define PDEF_SYS_EVENTMIN   0x0204 //................minutes until next event
#define PDEF_SYS_LASTCALLER 0x0205 //.....................name of last caller
#define PDEF_SYS_MENU       0x0206 //................name of the current menu
#define PDEF_SYS_MENUDIR    0x0207 //............directory for the menu files
#define PDEF_SYS_NODELIST   0x0208 //.............directory for the nodelists
#define PDEF_SYS_NODE       0x0209 //.............................node number
#define PDEF_SYS_PAGES      0x020A //......number of pages in current session
#define PDEF_SYS_PEX        0x020B //.......................the pex directory
#define PDEF_SYS_PORT       0x020C //.........system's active com port number
#define PDEF_SYS_PVTUP      0x020D //...............private uploads directory
#define PDEF_SYS_SHORTDOW   0x020E //.........current day of the week (short)
#define PDEF_SYS_STARTUP    0x020F //..............proboard startup directory
#define PDEF_SYS_SYSOP      0x0210 //.......................name of the sysop
#define PDEF_SYS_SYSTEM     0x0211 //...............proboard system directory
#define PDEF_SYS_TEXTFILES  0x0212 //.....................textfiles directory
#define PDEF_SYS_TIME       0x0213 //......................current time HH:MM
#define PDEF_SYS_TOTALCALLS 0x0214 //......................total system calls
#define PDEF_SYS_UPLOAD     0x0215 //...................main upload directory
#define PDEF_SYS_USERS      0x0216 //..................total users on the bbs
#define PDEF_SYS_VERSION    0x0217 //...................pb-lib version (x.xx)
#define PDEF_SYS_WEEKDAY    0x0218 //......................day of week (long)
//.........................................................messagebase tokens
#define PDEF_MSG_HMBDIR     0x0301 //...........directory for the Hudson base
#define PDEF_MSG_HMBLOW     0x0302 //...first message number for Hudson areas
#define PDEF_MSG_HMBTOTAL   0x0304 //......total messages in the Hudson areas
#define PDEF_MSG_LAST       0x0305 //..................number of last message
#define PDEF_MSG_TOTAL      0x0306 //..........total messages in current area
//......................................................user address and info
#define PDEF_USR_ADDRESS1   0x0401 //...................user's address line 1
#define PDEF_USR_ADDRESS2   0x0402 //...................user's address line 2
#define PDEF_USR_ADDRESS3   0x0403 //...................user's address line 3
#define PDEF_USR_ALIAS      0x0404 //............................user's alias
#define PDEF_USR_CITY       0x0405 //.............................user's city
#define PDEF_USR_COMMENT    0x0406 //...................comment line for user
#define PDEF_USR_COUNTRY    0x0407 //..........................user's country
#define PDEF_USR_DATA       0x0408 //.......................user's data phone
#define PDEF_USR_DOB        0x0409 //.......................user's birth date
#define PDEF_USR_FAX        0x040A //........................user's fax phone
#define PDEF_USR_FIRST      0x040B //.......................user's first name
#define PDEF_USR_NAME       0x040C //........................user's full name
#define PDEF_USR_PASSWD     0x040D //.........................user's password
#define PDEF_USR_RECNO      0x040E //....user's record number in the userbase
#define PDEF_USR_SEX        0x040F //..............................user's sex
#define PDEF_USR_STATE      0x0410 //............................user's state
#define PDEF_USR_VOICE      0x0411 //.....................user's voice number
//..........................................................user online setup
#define PDEF_USR_ANSI       0x0501 //.................ansi emulation (ON/OFF)
#define PDEF_USR_AVATAR     0x0502 //...............avatar emulation (ON/OFF)
#define PDEF_USR_AVTPLUS    0x0503 //............avatar/0+ emulation (ON/OFF)
#define PDEF_USR_CHECKFILES 0x0504 //...........should we check for new files
#define PDEF_USR_CHECKMAIL  0x0505 //............should we check for new mail
#define PDEF_USR_CLRSCR     0x0506 //...................clear screen (ON/OFF)
#define PDEF_USR_FLAGS      0x0507 //................user flags (all of them)
#define PDEF_USR_FLAGSA     0x0508 //.......................user flags (A..H)
#define PDEF_USR_FLAGSB     0x0509 //.......................user flags (I..P)
#define PDEF_USR_FLAGSC     0x050A //.......................user flags (Q..X)
#define PDEF_USR_FLAGSD     0x050B //.......................user flags (Y..6)
#define PDEF_USR_FORWARD    0x050C //...........forward messages to this name
#define PDEF_USR_FSED       0x050D //..............fullscreen editor (ON/OFF)
#define PDEF_USR_IBM        0x050E //............extended characters (ON/OFF)
#define PDEF_USR_ID         0x050F //......user's level ID from limits editor
#define PDEF_USR_LANGUAGE   0x0510 //........................current language
#define PDEF_USR_LEVEL      0x0511 //............................user's level
#define PDEF_USR_NUMLINES   0x0512 //...........................screen length
#define PDEF_USR_PAUSE      0x0513 //.................screen pausing (ON/OFF)
#define PDEF_USR_STACKING   0x0514 //...............command stacking (ON/OFF)
//...............................................user statistics and activity
#define PDEF_USR_CALLS      0x0601 //............user's total number of calls
#define PDEF_USR_CREDIT     0x0602 //..............user's netmail credit left
#define PDEF_USR_DELAY      0x0603 //...................user's download delay
#define PDEF_USR_DELAYLEFT  0x0604 //..............user's download delay left
#define PDEF_USR_DOWNS      0x0605 //........user's total number of downloads
#define PDEF_USR_EXPDAYS    0x0606 //...............user's days to expiration
#define PDEF_USR_EXPDATE    0x0607 //..................user's expiration date
#define PDEF_USR_FAREA      0x0608 //..................current file area name
#define PDEF_USR_FAREADIR   0x0609 //....data directory for current file area
#define PDEF_USR_FAREANO    0x060A //................current file area number
#define PDEF_USR_FGROUP     0x060B //......................current file group
#define PDEF_USR_FIRSTCALL  0x060C //.............date of first call for user
#define PDEF_USR_FGROUPNO   0x060D //...............current file group number
#define PDEF_USR_KBDOWN     0x060E //.................total KBytes downloaded
#define PDEF_USR_KBLEFT     0x060F //.................KBytes left to download
#define PDEF_USR_KBLIMIT    0x0610 //.................daily KB download limit
#define PDEF_USR_KBUP       0x0611 //...................total KBytes uploaded
#define PDEF_USR_LASTDATE   0x0612 //......................date of last login
#define PDEF_USR_LASTFILES  0x0613 //........date of last check for new files
#define PDEF_USR_LASTPWD    0x0614 //..date of last time password was changed
#define PDEF_USR_LASTTIME   0x0615 //.......................time of last call
#define PDEF_USR_MAREA      0x0616 //...............current message area name
#define PDEF_USR_MAREANO    0x0617 //.............current message area number
#define PDEF_USR_MGROUP     0x0618 //...................current message group
#define PDEF_USR_MGROUPNO   0x0619 //............current message group number
#define PDEF_USR_MINONLINE  0x061A //........minutes online (current session)
#define PDEF_USR_MLASTREAD  0x061B //.............number of last read message
#define PDEF_USR_MWRITTEN   0x061C //..................total messages written
#define PDEF_USR_SECONLINE  0x061D //...............seconds online (always 0)
#define PDEF_USR_SECTODAY   0x061E //................seconds today (always 0)
#define PDEF_USR_TLEFT      0x061F //........................time left online
#define PDEF_USR_TLIMIT     0x0620 //.................daily time limit (mins)
#define PDEF_USR_TONLINE    0x0621 //.................time spent online today
#define PDEF_USR_TTOTAL     0x0622 //.........total time spent online by user
#define PDEF_USR_UPLOADS    0x0623 //.................total number of uploads

/////////////////////////////////////////////////////////////////////////////
// parser style codes
/////////////////////////////////////////////////////////////////////////////
#define PDEF_JUST_LEFT      0x0001 //.....................left-justified text
#define PDEF_JUST_RIGHT     0x0002 //....................right-justified text
#define PDEF_JUST_CENTER    0x0003 //...........................centered text

/////////////////////////////////////////////////////////////////////////////
// codes for the actions to perform
/////////////////////////////////////////////////////////////////////////////
#define PDEF_ACTION_ERROR   0x0000 //.............unknown action code request
#define PDEF_ACTION_CLREOL  0x0001 //....................clear to end of line
#define PDEF_ACTION_CLRSCR  0x0002 //.................clear the entire screen
#define PDEF_ACTION_HANGUP  0x0003 //........................hangup the phone
#define PDEF_ACTION_PAUSE   0x0004 //..pause w/ prompt from the language file
#define PDEF_ACTION_PROMPT  0x0005 //...display prompt from the language file
#define PDEF_ACTION_DISPLAY 0x0006 //...............display another text file
#define PDEF_ACTION_PEXEC   0x0007 //.......................run a pex program
#define PDEF_ACTION_EXEC    0x0008 //.........run a normal executable program
#define PDEF_ACTION_BEEP    0x0009 //........................beep at the user
#define PDEF_ACTION_WAIT    0x000A //...........wait for 1 second (no prompt)

#endif /* INCLUDED_PARSEDEF_H */
