/*
 * This file is part of PB-Lib v3.0 C++ Programming Library
 *
 * Copyright (c) 1995, 1997 by Branislav L. Slantchev
 * A fine product of Silicon Creations, Inc. (gargoyle)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the License which accompanies this
 * software. This library is distributed in the hope that it will
 * be useful, but without any warranty; without even the implied
 * warranty of merchantability or fitness for a particular purpose.
 *
 * You should have received a copy of the License along with this
 * library, in the file LICENSE.DOC; if not, write to the address
 * below to receive a copy via electronic mail.
 *
 * You can reach Branislav L. Slantchev (Silicon Creations, Inc.)
 * at bslantch@cs.angelo.edu. The file SUPPORT.DOC has the current
 * telephone numbers and the postal address for contacts.
*/

#ifndef INCLUDED_LOG_H
#define INCLUDED_LOG_H

/*
 * f i l e   l o g g i n g   c l a s s
 * 
 * declaration of the generic file logging class with special format support
*/
#include "typedef.h"

#ifndef PB_SDK
	#include <stdio.h>
#else
	#include "pblibc.h"
#endif

class zLog
{
public:
	enum log_type { intermail, binkley, proboard };
	enum log_level{ normal, mesg, error, fatal };

	zLog(const char *fileName, log_type type);
	~zLog();

	void SetPID(const char *pid);
	void Open();
	void Close();
	void Write(log_level level, const char *format, ...);

private:
	static const char m_LevelChars[2][4];
	log_type m_LogType;
	Boolean  m_FileOpen;
	char    *m_FileName;
	char    *m_PID;
	FILE    *m_fp;
};

#endif /* logfile.h */