/*
 * This file is part of PB-Lib v3.0 C++ Programming Library
 *
 * Copyright (c) 1995, 1997 by Branislav L. Slantchev
 * A fine product of Silicon Creations, Inc. (gargoyle)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the License which accompanies this
 * software. This library is distributed in the hope that it will
 * be useful, but without any warranty; without even the implied
 * warranty of merchantability or fitness for a particular purpose.
 *
 * You should have received a copy of the License along with this
 * library, in the file LICENSE.DOC; if not, write to the address
 * below to receive a copy via electronic mail.
 *
 * You can reach Branislav L. Slantchev (Silicon Creations, Inc.)
 * at bslantch@cs.angelo.edu. The file SUPPORT.DOC has the current
 * telephone numbers and the postal address for contacts.
*/

#ifndef INCLUDED_LISTVIEW_H
#define INCLUDED_LISTVIEW_H

/*
 * l i s t   v i e w e r   c l a s s
 * 
 * generic listbox viewer class that uses a doubly-linked list of items
*/
#include "dlist.h"
#include "geometry.h"

// each record used by the list box must be defined from this class
class zListRecord
{
public:
	zListRecord();

	virtual void draw(const zPoint &origin, short maxlen) = 0;
	virtual void select(const zPoint &origin, short maxlen, Boolean off) = 0;
	virtual void toggleTag();

	short   m_rows;    // number of rows per description
	Boolean m_tagged;
};

////////////////////////////////////////////////////////////////////////////
class zListViewer
{
public:
	zListViewer(const zRect &bounds, zDoubleList *aList);

	void  handle(ushort &aKeyCode);	//...handle command (direction keys only)
	void  draw();					//....redraw a full-screen of the listbox
	void  setFocus(void *item);		//........set the focus to item from list
	void  drawFocus();				//............redisplays the focused item
	void  newList(zDoubleList *aList);      //..............assign a new list
	zListRecord* focused();         //...............get focused item
	Boolean lastItem() const;		//..............if last item is displayed
	Boolean firstItem() const;		//.............if first item is displayed
	void    setClearColor(uchar attrib);

protected:
	void  writeLiteBar(Boolean turnOff);
	void  getNextLimit(zListCursor &newLimit, zListCursor &whence);
	void  getPrevLimit(zListCursor &newLimit, zListCursor &whence);
	short rowsToSkip(zListCursor *from, zListCursor *to);

	zDoubleList *m_list;	 //........................yeah, this is the list
	zListCursor  m_focus;	 //......the iterator for the list (focused item)
	zListCursor  m_top;	     //..............the current top item on the list
	zListCursor  m_bottom;   //...........the current bottom item on the list
	zPoint		 m_where;	 //.................the selection bar coordinates
	zRect        m_bounds;   //............................bounding rectangle
	uchar        m_clearColor; //.........attribute to use for clearing lines
};

inline Boolean
zListViewer::lastItem() const
{
	return Boolean(m_bottom.atEnd());
}

inline Boolean
zListViewer::firstItem() const
{
	return Boolean(m_top.atStart());
}

inline zListRecord*
zListViewer::focused()
{
	return (zListRecord *)m_focus.get();
}

inline void
zListViewer::setClearColor(uchar attrib)
{
	m_clearColor = attrib;
}

#endif /* INCLUDED_LISTVIEW_H */
