/*
 * This file is part of PB-Lib v3.0 C++ Programming Library
 *
 * Copyright (c) 1995, 1997 by Branislav L. Slantchev
 * A fine product of Silicon Creations, Inc. (gargoyle)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the License which accompanies this
 * software. This library is distributed in the hope that it will
 * be useful, but without any warranty; without even the implied
 * warranty of merchantability or fitness for a particular purpose.
 *
 * You should have received a copy of the License along with this
 * library, in the file LICENSE.DOC; if not, write to the address
 * below to receive a copy via electronic mail.
 *
 * You can reach Branislav L. Slantchev (Silicon Creations, Inc.)
 * at bslantch@cs.angelo.edu. The file SUPPORT.DOC has the current
 * telephone numbers and the postal address for contacts.
*/

#ifndef INCLUDED_FEBBS_H
#define INCLUDED_FEBBS_H
#include "typedef.h"
#include "stdmac.h"

/////////////////////////////////////////////////////////////////////////////
// filebase directory class which supports FA_<n>.CTL files
/////////////////////////////////////////////////////////////////////////////
class zFileAreaDir
{
public:
	zFileAreaDir() { count = 0; }
	~zFileAreaDir(){ free();    }

	void  SetPath(const char *aPath, int areano, Boolean cdrom);
	char* Find(const char *fileName);

protected:
	void    free();
	short   count;
	Boolean cdrom;
	char   *paths[MAXPATH];
};

/////////////////////////////////////////////////////////////////////////////
// advanced files.bbs parsing class, also supports FA_nnn.CTL directory specs
/////////////////////////////////////////////////////////////////////////////
#define MAX_DESCSZ 1024

class zFbbsLine
{
public:
	enum line_content_t {   //...................flags for detected line parts
		name       = 0x01,  //...........................file name is present
		size       = 0x02,  //...........................file size is present
		date       = 0x04,  //...........................file date is present
		text       = 0x08,  //....................file description is present
		count      = 0x10,  //...............file download counter is present
		disk_date  = 0x20,  //..............file date was retrieved from disk
		disk_size  = 0x40,  //..............file size was retrieved from disk
		fake_count = 0x80   //....................fake download counter added
	};

	enum date_format_t {   //...........available date formatting enumeration
		american,          //.......................american-style (MM-DD-YY)
		european,          //.......................european-style (DD-MM-YY)
		japanese           //.......................japanese-style (YY-MM-DD)
	};

	zFbbsLine(date_format_t fmt = american, char lct = '[', char rct = ']');
	~zFbbsLine();

	void  SetPath(const char *path, int areano, Boolean cdrom);
	void  SetLine(const char *line);
	char *GetLine();

	const char *GetFileName() const  { return m_FileName;  }
	const char *GetFileSize() const  { return m_FileSize;  }
	const char *GetFileDate() const  { return m_FileDate;  }
	const char *GetFileCount() const { return m_FileCount; }
	const char *GetFileDesc() const  { return m_FileDesc;  }
		  int   GetFlags() const     { return m_Flags;     }

private:
	void    ResetVars();
	Boolean CheckSize(char *s);
	Boolean CheckDate(char *s);
	Boolean CheckCounter(char *s);
	void    GetFileSize(char *name);
	void    GetFileDate(char *name);
	void    GetDescription(char *s);

	zFileAreaDir *m_FindFile;       //....................file locator object
	int           m_Flags;          //........................bitmapped flags

	char         *m_DateFormat;     //.....................date format string
	char          m_DlCtLeft;       //........left download counter delimeter
	char          m_DlCtRight;      //.......right download counter delimeter

	char          m_FileName[13];   //.....................file name (if any)
	char          m_FileDate[9];    //.....................file date (if any)
	char          m_FileSize[15];   //.....................file size (if any)
	char          m_FileCount[8];   //..............download counter (if any)
	char          m_FileDesc[MAX_DESCSZ + 1]; //.........description (if any)
};

#endif /* INCLUDED_FEBBS_H */