/*
 * This file is part of PB-Lib v3.0 C++ Programming Library
 *
 * Copyright (c) 1995, 1997 by Branislav L. Slantchev
 * A fine product of Silicon Creations, Inc. (gargoyle)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the License which accompanies this
 * software. This library is distributed in the hope that it will
 * be useful, but without any warranty; without even the implied
 * warranty of merchantability or fitness for a particular purpose.
 *
 * You should have received a copy of the License along with this
 * library, in the file LICENSE.DOC; if not, write to the address
 * below to receive a copy via electronic mail.
 *
 * You can reach Branislav L. Slantchev (Silicon Creations, Inc.)
 * at bslantch@cs.angelo.edu. The file SUPPORT.DOC has the current
 * telephone numbers and the postal address for contacts.
*/

#ifndef INCLUDED_EDIT_H
#define INCLUDED_EDIT_H

/*
 * a d v a n c e d   s t r i n g   e d i t i n g
 * 
 * various advanced string editing, combo boxes and other data entry classes
*/
#include "geometry.h"

class edit_options
{
public:

	enum num{           //......................this is for zEditNumber class
		hex   = 1,      //............................enable hex input format
		blank = 2,      //.........................enable blank to be allowed
		pos   = 4       //..............................positive numbers only
	};
	enum date{          //........................this is for zEditDate class
		european = 1,   //...........................use european date format
		american = 2,   //...........................use american date format
		show     = 4,   //..............show the background format characters
		strict   = 8    //........................check the date for validity
	};
	enum file{          //........................this is for zEditFile class
		path      = 1,  //......................allow full path specification
		wildcards = 2,  //..........................allow wildcard characters
		upper     = 4   //...............................upper-case the input
	};
	enum combo{         //.......................this is for zEditCombo class
		dispose = 1,    //......................dispose of the list when done
		init    = 2     //.................auto-load first item from the list
	};
};

// the palette layout for zEditLine is as follows:
//
//		palette[0]	- active foreground color
//		palette[1]	- not used
//		palette[2]	- active background color
//		palette[3]	- active background fill character
//		palette[4]	- active selection color
//		palette[5]	- not used
//		palette[6]	- inactive foreground color
//		palette[7]	- not used
//		palette[8]	- inactive background color
//		palette[9]	- inactive background fill character

////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
class zEditLine
{
public:
	zEditLine(const zRect &bounds, short maxLen);
	virtual ~zEditLine();

    virtual void    draw();
    virtual void    drawView();
    virtual void    handle(ushort aKeyCode);
    virtual void    setPalette(const char *aPalette);
    virtual void    setState(Boolean enable);
	virtual Boolean getState();
    virtual void    setData(void *ptr);
	virtual void    getData(void *ptr);
	virtual char    OnDraw(char aChar){ return aChar; }

	static char leftArrow;		// these are the scroll indicators
    static char rightArrow;		// can be changed by the caller program

protected:
	uchar   getPalette(short pos);	// retrieve palette color or character
    Boolean canScroll(Boolean left);
    void    deleteSelect();
    void    selectAll();
    void    rightWord();
    void    leftWord();
    void    zapWord();

    char     palette[10];	// palette
    Boolean  mustPatch;	// patch the output handle() to make char visible
    Boolean  focused;	// is the view focused (used by draw() for colors)
    Boolean  insertMode;// insert mode flag
	char    *data;		// pointer to the string being edited
    short    firstPos;	// first position to display
    short    curPos;	// index of the current cursor position
    short    startSel;	// index of the selection start character
    short    endSel;	// index of the selection end character
    short    maxLen;	// maximum allowable length of the string
	zPoint   origin;	// the origin of the input line
	zPoint   size;		// the size (horizontal and vertical)
};

////////////////////////////////////////////////////////////////////////////
// Class to input numbers
////////////////////////////////////////////////////////////////////////////
class zEditNumber: public zEditLine
{
public:
	zEditNumber(const zRect &bounds, short aMaxLen, short aOptions);

    virtual void getData(void *ptr);
    virtual void setData(void *ptr);
	virtual void handle(ushort aKeyCode);

protected:
	short options;
};

////////////////////////////////////////////////////////////////////////////
// Class to input dates
////////////////////////////////////////////////////////////////////////////
class zEditDate: public zEditNumber
{
public:
	zEditDate(const zRect &bounds, short aOptions);

    virtual void getData(void *ptr);
    virtual void setData(void *ptr);
    virtual void handle(ushort aKeyCode);
    virtual Boolean valid(ushort aKeyCode);

protected:
	static const char *euro;
    static const char *amer;
    static const char *none;
	short options;
};

////////////////////////////////////////////////////////////////////////////
// Class to input file names and paths
////////////////////////////////////////////////////////////////////////////
class zEditFile: public zEditLine
{
public:
	zEditFile(const zRect &bounds, short aMaxLen, short aOptions);
    virtual void handle(ushort aKeyCode);

protected:
	short options;
};

////////////////////////////////////////////////////////////////////////////
// Class for combo box input line with speed searches and toggles
////////////////////////////////////////////////////////////////////////////
class zDoubleList;
class zListCursor;

class zEditCombo: public zEditLine
{
public:
	zEditCombo(const zRect &bounds, short Options, zDoubleList *items);
    ~zEditCombo();

    virtual void handle(ushort aKeyCode);
    virtual void getData(void *ptr);
    virtual void setData(void *ptr);

protected:
	void incrementalSearch(ushort aKeyCode);

    short        nCompare;
	short        options;
	zDoubleList *list;
	zListCursor *iter;
};

////////////////////////////////////////////////////////////////////////////
// Class for accepting passwords as input
////////////////////////////////////////////////////////////////////////////
class zEditPassword: public zEditLine
{
public:
	zEditPassword(const zRect &bounds, short aMaxLen);
	virtual char setPwdChar(char aChar);

protected:
	char  OnDraw(char /*aChar*/ ){ return pwdChar; }
	char  pwdChar;
};

#endif /* INCLUDED_EDIT_H */
