/*
 * This file is part of PB-Lib v3.0 C++ Programming Library
 *
 * Copyright (c) 1995, 1997 by Branislav L. Slantchev
 * A fine product of Silicon Creations, Inc. (gargoyle)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the License which accompanies this
 * software. This library is distributed in the hope that it will
 * be useful, but without any warranty; without even the implied
 * warranty of merchantability or fitness for a particular purpose.
 *
 * You should have received a copy of the License along with this
 * library, in the file LICENSE.DOC; if not, write to the address
 * below to receive a copy via electronic mail.
 *
 * You can reach Branislav L. Slantchev (Silicon Creations, Inc.)
 * at bslantch@cs.angelo.edu. The file SUPPORT.DOC has the current
 * telephone numbers and the postal address for contacts.
*/

#ifndef INCLUDED_DLIST_H
#define INCLUDED_DLIST_H

/*
 * d o u b l y   l i n k e d   l i s t   c l a s s e s
 * 
 * this is the declaration of the doubly-linked list data structure classes
*/
#include "typedef.h"

// the list node element
class zDLNode
{
	friend class zListCursor;
    friend class zDoubleList;
    friend class zDLSortedList;

public:
    zDLNode(void *aData = 0): data(aData){}

private:
	zDLNode *next, *prev;
    void    *data;
};

// list iterator class
class zListCursor
{
public:
	zListCursor(zDoubleList &aList, Boolean atStart = True);
    zListCursor(zListCursor &aListCursor);

	ushort  begin();
    ushort  end();
    ushort  next();
    ushort  prev();
    void    sync();
    void   *get() const;
    ushort  update(void *data);

    ushort  operator++(){ return next(); }
    ushort  operator++(int){ return next(); }
    ushort  operator--(){ return prev(); }
    ushort  operator--(int){ return prev(); }
    ushort  operator+=(short nelem);
    ushort  operator-=(short nelem);
    void   *operator()() const { return get(); }

    zListCursor& operator=(zListCursor &aListCursor);

    Boolean atEnd() const;
    Boolean atStart() const;

protected:
	zDoubleList &list;
    long         cpos;
    zDLNode     *focus;
};

// the list class
class zDoubleList
{
	friend class zListCursor;

public:
	zDoubleList(Boolean shouldPurge = False);
	virtual ~zDoubleList();

	virtual ushort link(void *data);
    virtual ushort append(void *data);
    virtual ushort prepend(void *data);
	virtual ushort unlink();
	virtual ushort unlink(void* &data);

    ushort  next();
    ushort  prev();
    ushort  begin();
    ushort  end();

    ushort  operator++(){ return next(); }
    ushort  operator++(int){ return next(); }
    ushort  operator--(){ return prev(); }
	ushort  operator--(int){ return prev(); }
	ushort  operator-=(short nelem);
	ushort  operator+=(short nelem);
	void   *operator()() const { return get(); }

	Boolean atEnd() const { return (cpos == count) ? True : False; }
	Boolean atStart() const { return (1L == cpos) ? True : False; }

	void    forEach(fpAppFunc, void *arg = 0);
	ushort  firstThat(fpTestFunc test, void *arg = 0);
	ushort  lastThat(fpTestFunc test, void *arg = 0);

	ushort  update(void *data);

	void   *get() const { return count ? focus->data : 0; }
	long    size() const { return count; }
	ushort  error(){ ushort e = err; err = 0; return e; }

protected:
	virtual void freeData(void *data){ delete data; }

	zDLNode       *root;    // root->next is the head, root is the tail
	zDLNode       *focus;   // currently focused item
	long           count;   // number of elements in the list
	long           cpos;    // current position in the list
	ushort         err;     // error status
	Boolean        purge;   // should we purge the objects on deletion
};

////////////////////////////////////////////////////////////////////////////
// sorted list class
////////////////////////////////////////////////////////////////////////////
class zDLSortedList: public zDoubleList
{
	friend class zListCursor;

public:
	zDLSortedList(Boolean shouldPurge): zDoubleList(shouldPurge){}
	~zDLSortedList(){ zDoubleList::~zDoubleList(); }

	ushort link(void *data);

protected:
	virtual int   compare(void *key1, void *key2) = 0;
	virtual void *keyOf(void *data) = 0;
};

#endif /* INCLUDED_DLIST_H */
