/*
 * This file is part of PB-Lib v3.0 C++ Programming Library
 *
 * Copyright (c) 1995, 1997 by Branislav L. Slantchev
 * A fine product of Silicon Creations, Inc. (gargoyle)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the License which accompanies this
 * software. This library is distributed in the hope that it will
 * be useful, but without any warranty; without even the implied
 * warranty of merchantability or fitness for a particular purpose.
 *
 * You should have received a copy of the License along with this
 * library, in the file LICENSE.DOC; if not, write to the address
 * below to receive a copy via electronic mail.
 *
 * You can reach Branislav L. Slantchev (Silicon Creations, Inc.)
 * at bslantch@cs.angelo.edu. The file SUPPORT.DOC has the current
 * telephone numbers and the postal address for contacts.
*/

#ifndef INCLUDED_DATE_H
#define INCLUDED_DATE_H
#include "typedef.h"

class zDate
{
public:
	enum month {
		jan = 1, feb, mar, apr, may, jun, jul, aug, sep, oct, nov, dec
	};

	enum week_day {
		mon = 1, tue, wed, thu, fri, sat, sun
	};

	enum moon_phase {
		new_moon, waxing_crescent, first_quater, waxing_gibbous,
		full_moon, waning_gibbous, third_quater, waning_crescent
	};

	zDate();
	zDate(month month, int day, int year);
	zDate(int dayOfYear, int year);
	zDate(const zDate &aDate);
	zDate(ulong nDayNumber);
	zDate(const struct tm *date);

	zDate             AddMonths(int nMonths) const;
	zDate             AddWeeks(int nWeeks) const;
	zDate             AddYears(int nYears) const;
	int               Age(const zDate &aDate) const;
	zDate             BeginDST() const;
	static zDate      BeginDST(int aYear);
	int               Day() const;
	ulong             DayNumber() const;
	week_day          DayOfWeek() const;
	int               DayOfYear() const;
	int               DaysInMonth() const;
	static int        DaysInMonth(month aMonth, int aYear);
	int               DaysInYear() const;
	static int        DaysInYear(int year);
	zDate             Easter() const;
	static zDate      Easter(int year);
	zDate             EndDST() const;
	static zDate      EndDST(int aYear);
	Boolean           IsDST() const;
	static Boolean    IsDST(const zDate &date);
	Boolean           IsLeapYear() const;
	static Boolean    IsLeapYear(int year);
	Boolean           IsValid() const;
	static Boolean    IsValid(month aMonth, int aDay, int aYear);
	month             Month() const;
	moon_phase        MoonPhase() const;
	static moon_phase MoonPhase(const zDate &date);
					  operator long() const;
	Boolean           operator!=(const zDate &aDate) const;
	zDate             operator+(int nDays) const;
	zDate             operator+(long nDays) const;
	zDate             operator++();
	zDate             operator++(int);
	zDate&            operator+=(int nDays);
	zDate&            operator+=(long nDays);
	long              operator-(const zDate &aDate) const;
	zDate             operator-(int nDays) const;
	zDate             operator-(long nDays) const;
	zDate             operator--();
	zDate             operator--(int);
	zDate&            operator-=(int nDays);
	zDate&            operator-=(long nDays);
	Boolean           operator<(const zDate &aDate) const;
	Boolean           operator<=(const zDate &aDate) const;
	zDate&            operator=(const zDate &aDate);
	Boolean           operator==(const zDate &aDate) const;
	Boolean           operator>(const zDate &aDate) const;
	Boolean           operator>=(const zDate &aDate) const;
	char              operator[](int index) const;
	static void       SetBeginDST(month aMonth, week_day aWeekDay);
	static void       SetEndDST(month aMonth, week_day aWeekDay);
	static zDate      Today();
	int               WeekOfMonth() const;
	int               WeekOfYear() const;
	int               WeeksInYear() const;
	static int        WeeksInYear(int year);
	int               Year() const;

	// Pope Gregor XIII's reform cancelled 10 days:
	// the day after Oct 4 1582 was Oct 15 1582
	static const int      ReformYear;
	static const month    ReformMonth;
	static const ulong    ReformDayNumber;

protected:
	// Daylight Savings Time Month and Day of Week
	static month    BeginDSTMonth;
	static week_day BeginDSTDay;
	static month    EndDSTMonth;
	static week_day EndDSTDay;

protected:
	zDate Set(month aMonth, int aDay, int aYear);
	ulong MakeDayNumber() const;
	void  FromDayNumber(ulong nDayNumber);

private:
	month m_month;
	int   m_day;
	int   m_year;
	ulong m_dayno;
};

/*
 * inline functions that belong to the zDate class
*/

inline int
zDate::Year() const
{
	return m_year;
}

inline int
zDate::Day() const
{
	return m_day;
}

inline zDate::month
zDate::Month() const
{
	return m_month;
}

inline ulong
zDate::DayNumber() const
{
	return m_dayno;
}

#endif /* INCLUDED_DATE_H */
