/*
 * This file is part of PB-Lib v3.0 C++ Programming Library
 *
 * Copyright (c) 1995, 1997 by Branislav L. Slantchev
 * A fine product of Silicon Creations, Inc. (gargoyle)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the License which accompanies this
 * software. This library is distributed in the hope that it will
 * be useful, but without any warranty; without even the implied
 * warranty of merchantability or fitness for a particular purpose.
 *
 * You should have received a copy of the License along with this
 * library, in the file LICENSE.DOC; if not, write to the address
 * below to receive a copy via electronic mail.
 *
 * You can reach Branislav L. Slantchev (Silicon Creations, Inc.)
 * at bslantch@cs.angelo.edu. The file SUPPORT.DOC has the current
 * telephone numbers and the postal address for contacts.
*/

#ifndef INCLUDED_COMPILER_H
#define INCLUDED_COMPILER_H

/*
 * c r o s s - c o m p i l e r   d e f i n i t i o n s
 * 
 * these macros port several important routines across some ms-dos compilers
*/

/*
 * generic MS-DOS filesearch record (ffblk and find_t-compatible)
 * this should be aligned on byte-boundary. DJGPP assumes #pragma align 1
 * as default (and it cannot be turned off anyway).
*/
#if defined( __TURBOC__ )
	#pragma option -a-
#elif defined( __ZTC__ )
	#pragma ZTC align 1
#elif defined( __SC__ )
	#pragma SC align 1
#elif defined( _MSC_VER ) || defined( __WATCOMC__ )
	#pragma pack(1)
#endif

typedef struct{
	char     reserved[21];
	char     attrib;
	unsigned time;
	unsigned date;
	long     size;
	char     name[13];
} zDosFile;

/*
 * restore the default alignment here
*/
#if defined( __TURBOC__ )
	#pragma option -a.
#elif defined( __ZTC__ )
	#pragma ZTC align
#elif defined( __SC__ )
	#pragma SC align
#elif defined( _MSC_VER ) || defined( __WATCOMC__ )
	#pragma pack ()
#endif

/*
 * map the find_first, find_next combo onto the provided library functions
*/
#ifdef PB_SDK
	#define FindFirst(p,a,ff)   dos_findfirst(p,a,(struct find_t *)ff)
	#define FindNext(ff)        dos_findnext((struct find_t *)ff)
#elif defined( __DJGPP__ )
	#include <dir.h>
	#define FindFirst(path,attr,ff)  findfirst(path,(struct ffblk *)ff,attr)
	#define FindNext(ff)             findnext((struct ffblk *)ff)
#else
	#if defined( __ZTC__ )
	#define MSDOS 1
	#endif
	#include <dos.h>
	#define FindFirst(p,a,ff)  _dos_findfirst(p,a,(struct find_t *)ff)
	#define FindNext(ff)       _dos_findnext((struct find_t *)ff)
#endif

#ifndef PB_SDK
	#if defined( __WATCOMC__ ) || defined ( _MSC_VER )
		#define FA_NORMAL  _A_NORMAL
		#define FA_RDONLY  _A_RDONLY
		#define FA_HIDDEN  _A_HIDDEN
		#define FA_SYSTEM  _A_SYSTEM
		#define FA_LABEL   _A_VOLID
		#define FA_DIREC   _A_SUBDIR
		#define FA_ARCH    _A_ARCH
		#define FA_ALL     0x37
	#else
		#define FA_NORMAL  0x00
		#define FA_ALL     0x37
	#endif
#else /* the other SDK values are defined in PBLIBC.H */
	#define FA_ALL     0x37
#endif

#endif  /* INCLUDED_COMPILER_H */
