/*
 * This file is part of PB-Lib v3.0 C++ Programming Library
 *
 * Copyright (c) 1995, 1997 by Branislav L. Slantchev
 * A fine product of Silicon Creations, Inc. (gargoyle)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the License which accompanies this
 * software. This library is distributed in the hope that it will
 * be useful, but without any warranty; without even the implied
 * warranty of merchantability or fitness for a particular purpose.
 *
 * You should have received a copy of the License along with this
 * library, in the file LICENSE.DOC; if not, write to the address
 * below to receive a copy via electronic mail.
 *
 * You can reach Branislav L. Slantchev (Silicon Creations, Inc.)
 * at bslantch@cs.angelo.edu. The file SUPPORT.DOC has the current
 * telephone numbers and the postal address for contacts.
*/

#ifndef INCLUDED_COMDEF_H
#define INCLUDED_COMDEF_H

#ifndef __MINMAX_DEFINED
#define __MINMAX_DEFINED

#ifdef MINMAX_TEMPLATE

template <class ClassType>
inline const ClassType&
min(const ClassType &a, const ClassType &b)
{
	return (a < b) ? a : b;
}

template <class ClassType>
inline const ClassType&
max(const ClassType &a, const ClassType &b)
{
	return (a > b) ? a : b;
}

#else

#define min(a,b) ((a) <= (b) ? (a) : (b))
#define max(a,b) ((a) >= (b) ? (a) : (b))

#endif /* templatized versions */

#endif /* __MINMAX_DEFINED */

template <class ClassType>
inline void
swap(ClassType &a, ClassType &b)
{
	ClassType temp = a;
	a = b;
	b = temp;
}

/*
 * b i t   m a n i p u l a t i o n   f o r   i n t e g r a l   t y p e s
 * 
 * these bit manipulation macros work with integers, chars and longs. note
 * that bits are conventionally numbered from right to left, 0 to 7, 15 or 31
*/
#define iTestBit(value, bitno)   Boolean((value) & (1L << (bitno)))
#define iSetBit(value, bitno)    ( (value) |=  (1L << (bitno)) )
#define iClearBit(value, bitno)  ( (value) &= ~(1L << (bitno)) )
#define iToggleBit(value, bitno) ( (value) ^=  (1L << (bitno)) )

/*
 * b i t   m a n i p u l a t i o n   f o r   a r r a y s
 * 
 * these macros manipulate bits in arrays of 8-bit chars. note that the bits
 * are numbered consecutively, starting from 0, up to the number of chars in
 * the array * 8 - 1. (an array of 10 chars will hold 80 bits, from 0 to 79)
*/
#define TestBit(a, bitno)       Boolean(a[(bitno)>>3] & (1<<((bitno) & 7)))
#define SetBit(a, bitno)        ( a[(bitno) >> 3] |=  (1 << ((bitno) & 7)) )
#define ClearBit(a, bitno)      ( a[(bitno) >> 3] &= ~(1 << ((bitno) & 7)) )
#define ToggleBit(a, bitno)     ( a[(bitno) >> 3] ^=  (1 << ((bitno) & 7)) )

#endif /* INCLUDED_COMDEF_H */
