/*
 * This file is part of PB-Lib v3.0 C++ Programming Library
 *
 * Copyright (c) 1995, 1997 by Branislav L. Slantchev
 * A fine product of Silicon Creations, Inc. (gargoyle)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the License which accompanies this
 * software. This library is distributed in the hope that it will
 * be useful, but without any warranty; without even the implied
 * warranty of merchantability or fitness for a particular purpose.
 *
 * You should have received a copy of the License along with this
 * library, in the file LICENSE.DOC; if not, write to the address
 * below to receive a copy via electronic mail.
 *
 * You can reach Branislav L. Slantchev (Silicon Creations, Inc.)
 * at bslantch@cs.angelo.edu. The file SUPPORT.DOC has the current
 * telephone numbers and the postal address for contacts.
*/

#ifndef INCLUDED_CMDBAR_H
#define INCLUDED_CMDBAR_H
#include "geometry.h"

/*
 * c o m m a n d   b a r   c l a s s e s
 * 
 * these are the declarations of the command bar and command item classes.
*/

const short
	cmNoCommand = -1, cmCancel = -2; // reserved by the handler

class zCommandItem
{
	friend class zCommandBar;
	friend class TLangEntry;
	friend zCommandItem* operator+(zCommandItem *item, zCommandItem &link);

public:
	zCommandItem(const char *aText, ushort key, ushort aCmd, zCommandItem *next = 0);

protected:
	zCommandItem *next;	//..................................link to next item
	zCommandItem *prev;	//..............................link to previous item
	const char  *text;	//.....text to display (with '~' for highlight chars)

	ushort  keyCode;	//........key that activates the item (not sensitive)
	ushort  command;	//...................command generated when activated
	Boolean enabled;	//............................item is enabled if True
};

class zCommandBar
{
public:
	enum cbar_options
	{
		hide  = 1,  //.......................hide the command bar (invisible)
		focus = 2,  //.......................focus (receives events and acts)
		delim = 4   //............treat 1st and last chars of items specially
	};

	zCommandBar(const zRect &bounds, zCommandItem *items);
	~zCommandBar();

	virtual short handle(ushort aKeyCode);
	virtual void  draw();

	void  show(Boolean enable);
	void  setState(Boolean focused);

	void  setPalette(const char *aPalette);
	uchar getColor(short aColor);
	void  enableCommand(ushort aCommand, Boolean enable);

	ushort options;

protected:
	void          drawItem(const zCommandItem *item);
	short         getItemPos(const zCommandItem *item);
	void          focusItem(const zCommandItem *item);
	zCommandItem* lastItem();
	zCommandItem* firstItem();
	zCommandItem* prevItem();
	zCommandItem* nextItem();

	zPoint       origin;
	zPoint       size;
	char         palette[15];
	zCommandItem *items;
	zCommandItem *current;
};

// Global functions and utilities
zCommandItem* operator+(zCommandItem *item, zCommandItem &link);

// inlined functions
inline void
zCommandBar::show(Boolean mustShow)
{
	if( mustShow ) options &= ~hide;
	else options |= hide;
	draw();
}

inline void
zCommandBar::setState(Boolean focused)
{
	if( focused ) options |= focus;
	else options &= ~focus;
	draw();
}

#endif /* INCLUDED_CMDBAR_H */
