/*
 * PB-Lib C/C++ Library Version 0.021
 *
 * Copyright (C) 1995 by Branislav L. Slantchev
 * A product of Silicon Creations, Inc.
 *
 * See the file "copying.pbl" for licensing information.
*/

#ifndef __STDINI_H
#define __STDINI_H

/*
 ***************************************************************************
	   INI file manipulation and offline versions of Get/SetIniVar
 ***************************************************************************
*/
#ifndef __PBLIB_H
#include <pblib.h>
#endif

#ifndef PB_SDK
	#include <stdio.h>
	#include <string.h>
	#include <ctype.h>
#endif

#define MAX_INI_LINE 255

#ifdef __cplusplus
	extern "C" {
#endif

int IniWrite( const char *filename, const char *secName,
			  const char *varName, const char *value );
int IniReadStr( const char *filename, const char *secName,
				const char *varName, char *value, const char *defaultStr );
int IniReadInt( const char *filename, const char *secName,
				const char *varName, int *value, const int defaultInt );
int IniReadLong( const char *filename, const char *secName,
				const char *varName, long *value, const long defaultLong );
int IniReadBool( const char *filename, const char *secName,
				 const char *varName, bool *value, const bool defaultBool );

#ifdef __cplusplus
	}
#endif
#endif
