/*
 * PB-Lib C/C++ Library Version 0.021
 *
 * Copyright (C) 1995 by Branislav L. Slantchev
 * A product of Silicon Creations, Inc.
 *
 * See the file "copying.pbl" for licensing information.
*/

#ifndef __PROUTIL_H
#define __PROUTIL_H

#ifndef __PBLIB_H
#include <pblib.h>
#endif

#ifndef PB_SDK
#include <stdio.h>
#include <time.h>
#include <string.h>
#endif

#define MAX_KBDBUF   16         /* maximum length of the keyboard buffer */
#define PBLANG_DEFS 394         /* number of records in language files   */

/*
 * structures for the xlat??? functions
*/
typedef struct{
	LANGREC  def;               /* record for that language string       */
	char    *val;               /* the string itself                     */
	char    *keys;              /* the hotkey list (if applicable)       */
} xlat_t;

typedef char* xlts_t;           /* value used by xlatDisp, xlatCompile   */


/* structure for the ul?? functions */
typedef struct{
	char      file[13];         /* name of the file uploaded             */
	char      name[36];         /* uploader's name                       */
	struct tm date;             /* date and time of the upload           */
} upload_t;


#ifdef __cplusplus
	extern "C" {
#endif

/*
 * Create a fully-qualified path for filename
*/
char *_mkSysPath( const char *filename );
char *_mkUserPath( const char *filename );

/*
 * open a file in ProBoard's system and userbase directories
*/
FILE *pbfopen( const char *filename, const char *mode );
FILE *usrfopen( const char *filename, const char *mode );
int   UserBackup( const char *filename );

/*
 * generic file record numbering, reading and writing functions
*/
long NumFileRecs( const char *filename, size_t width );
int  WriteFileRec( const char *filename, long recNum,
				   const void *rec, size_t width );
int  ReadFileRec( const char *filename, long recNum,
				   void *rec, size_t width );

/*
 * Extended keyboard support
*/
void kbInit( void );
void kbDeinit( void );
void kbFlush( void );
int  kbGetKey( bool *local );
int  kbPeekKey( bool *local );

/*
 * process UPLOAD.LOG file
*/
int  ulGetFirst( upload_t *rec );
int  ulGetNext( upload_t *rec  );

/*
 * language support
*/
int    xlatLoad( int id, xlat_t *rec, const char *language );
void   xlatFree( xlat_t *rec );
xlts_t xlatCompile( const xlat_t *rec );
void   xlatDisp( const xlts_t s, bool ansiOn );

/*
 * combined boards manipulation
 * if you define __BOARD_NOMAC, you get the functions
*/
#ifndef __BOARD_NOMAC
#define GetBoard(n,b)      ( (b)[(n) >> 3] & (1 << ((n) & 0x07)) )
#define SetBoard(n,b)      do (b)[(n) >> 3] |= 1 << ((n) & 0x07); while(0)
#define ToggleBoard(n,b)   do (b)[(n) >> 3] ^= 1 << ((n) & 0x07); while(0)
#define UnsetBoard(n,b)    do (b)[(n) >> 3] &= ~(1 << ((n) & 0x07)); while(0)
#define SetAllBoards(b)    memset( b, 1, sizeof(combinedboards) )
#define UnsetAllBoards(b)  memset( b, 0, sizeof(combinedboards) )
#else
bool GetBoard( int num, combinedboards boards );
void SetBoard( int num, combinedboards boards );
void ToggleBoard( int num, combinedboards boards );
void UnsetBoard( int num, combinedboards boards );
void UnsetAllBoards( combinedboards boards );
void SetAllBoards( combinedboards boards );
#endif

/*
 * get status from the TimeFrame structure
*/
#ifndef __TFRAME_NOMAC
#define tfGetEnable(tFrame, t)                                           \
	BOOL( tFrame[(!t->tm_wday) ? 6 : t->tm_wday - 1][t->tm_hour >> 2] &  \
		(1 << (((t->tm_hour % 4) << 1) + ((t->tm_min > 30) ? 1 : 0) )) )
#else
bool tfGetEnable( TimeFrame tfDef, const struct tm *timer );
#endif

/*
 * filebase manipulation
*/
int  NumFileGroups( void );
int  ReadFileGroup( int groupNum, FILEGROUP *fg );

int  OpenFileIndex( void );
int  CloseFileIndex( void );
int  SearchFileIndex( char *match, const char *mask );
void RewindFileIndex( void );

/*
 * userbase manipulation
*/
long GetNumUsers( void );

void MakeUserIndex( USERSIDX *rec, const char *name, const char *alias );
long FindUserName( const char *name );
long FindUserAlias( const char *alias );

int  ReadUserBBS( USERS *rec, long recNum );
int  ReadUserPB( USERSPB *rec, long recNum );
int  ReadUserXI( USERSXI *rec, long recNum );
int  ReadUserIDX( USERSIDX *rec, long recNum );

int  WriteUserBBS( const USERS *rec, long recNum );
int  WriteUserPB( const USERSPB *rec, long recNum );
int  WriteUserXI( const USERSXI *rec, long recNum );
int  WriteUserIDX( const USERSIDX *rec, long recNum );

/*
 * messagebase manipulation
*/
int NumMsgGroups( void );
int ReadMsgGroup( int groupNum, MSGROUP *mg );

/*
 * UserDoes support
*/
#define USERDOES_LEN 0x16

int userd_creat( const char *fmt, ... );
int userd_unlink( void );

/*
 * conversion routines for MegaNums and longs (used for RIP support)
*/
char *ltom( long value );
long  mtol( const char *meganum );

/*
 * offline version of miscellaneous ProBoard SDK functions
*/
#ifndef PB_SDK
void Input( char *buf, int len, int readmode );
int  NumFileAreas( void );
int  ReadFileArea( int areaNum, FILEAREA *fa );
int  ReadUser( USER_REC *rec, long recNum );
void WriteUser( const USER_REC *rec );
int  __writeUserRec( const USER_REC *rec );
bool ReadMsgArea( int areaNum, MSGAREA *ma );
int  NumMsgAreas( void );
bool GetIniVar( char *filename, char *var, char *value, int len );
bool SetIniVar( char *filename, char *var, char *value );
#endif

#ifdef __cplusplus
	}
#endif
#endif
