/*
 * PB-Lib C/C++ Library Version 0.021
 *
 * Copyright (C) 1995 by Branislav L. Slantchev
 * A product of Silicon Creations, Inc.
 *
 * See the file "copying.pbl" for licensing information.
*/

#ifndef __PORTABLE_H
#define __PORTABLE_H

/*
 * generic MS-DOS filesearch record (ffblk and find_t-compatible)
 * this should be aligned on byte-boundary. DJGPP assumes #pragma align 1
 * as default (and it cannot be turned off anyway).
*/
#if defined( __TURBOC__ )
#pragma option -a-
#elif defined( __ZTC__ )
#pragma ZTC align 1
#elif defined( __SC__ )
#pragma SC align 1
#elif defined( _MSC_VER ) || defined( __WATCOMC__ )
#pragma pack(1)
#endif

typedef struct{
	char     reserved[21];
	char     attrib;
	unsigned time;
	unsigned date;
	long     size;
	char     name[13];
} _dos_ffblk;

/*
 * restore the default alignment here
*/
#if defined( __TURBOC__ )
#pragma option -a.
#elif defined( __ZTC__ )
#pragma ZTC align
#elif defined( __SC__ )
#pragma SC align
#elif defined( _MSC_VER ) || defined( __WATCOMC__ )
#pragma pack ()
#endif

/*
 * map the find_first, find_next combo onto the provided library functions
*/
#ifdef PB_SDK
#define ff_findfirst(p,a,ff)   dos_findfirst(p,a,(struct find_t *)ff)
#define ff_findnext(ff)        dos_findnext((struct find_t *)ff)
#else /* not the SDK */
#ifdef __GNUC__
#include <dir.h>
#define ff_findfirst(path,attr,ff)  findfirst(path,(struct ffblk *)ff,attr)
#define ff_findnext(ff)             findnext((struct ffblk *)ff)
#else /* not DJGPP */
#include <dos.h>
#define ff_findfirst(p,a,ff)  _dos_findfirst(p,a,(struct find_t *)ff)
#define ff_findnext(ff)       _dos_findnext((struct find_t *)ff)
#endif /* __GNUC__ */
#endif /* PB_SDK */

#ifndef PB_SDK
	#if defined( __WATCOMC__ ) || defined ( _MSC_VER )
		#define FA_NORMAL  _A_NORMAL
		#define FA_RDONLY  _A_RDONLY
		#define FA_HIDDEN  _A_HIDDEN
		#define FA_SYSTEM  _A_SYSTEM
		#define FA_LABEL   _A_VOLID
		#define FA_DIREC   _A_SUBDIR
		#define FA_ARCH    _A_ARCH
		#define FA_ALL     0x37
	#else
		#define FA_NORMAL  0x00
		#define FA_ALL     0x37
	#endif
#else /* the other SDK values are defined in _PBSTDC.H */
	#define FA_ALL     0x37
#endif

#endif
