/*
 * PB-Lib C/C++ Library Version 0.021
 *
 * Copyright (C) 1995 by Branislav L. Slantchev
 * A product of Silicon Creations, Inc.
 *
 * See the file "copying.pbl" for licensing information.
*/

#ifndef __MACDEF_H
#define __MACDEF_H

/*
 ***************************************************************************
              Macro definitions common to all PB-Lib library
 ***************************************************************************
*/

/*
 * far and NULL declarations
*/
#ifdef _MSC_VER
#ifdef M_I86SM
	#define __SMALL__
#endif
#ifdef M_I86MM
	#define __MEDIUM__
#endif
#ifdef M_I86CM
	#define __COMPACT__
#endif
#ifdef M_I86LM
	#define __LARGE__
#endif
#ifdef M_I86HM
	#define __HUGE__
#endif
#endif

#if defined(__COMPACT__) || defined( __LARGE__ ) || defined( __HUGE__ )
	#define __FAR   far
	#ifndef NULL
	#define NULL (0L)
	#endif
#else
	#define __FAR
	#ifndef NULL
	#define NULL (0)
	#endif
#endif

/*
 * some trivial stuff, I don't think anybody would define only one
*/
#ifndef FALSE
#define FALSE (0)
#define TRUE  (1)
#endif

/*
 * this will always be 1 or 0
*/
#define BOOL(x)        ( !(!(x)) )

/*
 * Swap any objects, give their type as third parameter
*/
#define SWAP(a,b,type) do{ type __tswap = a; a = b; b = __tswap; }while(0)

/*
 * Cast any object to any type
*/
#define CAST(a,type)  ( *((type __FAR *)&(a)) )

/*
 * Return min, max of two integral types: be careful with ++ and --
*/
#define MIN(a,b)   ((a)-(b) <= 0 ? (a) : (b))
#define MAX(a,b)   ((a)-(b) >= 0 ? (a) : (b))

/*
 * Extract high and low order bytes from a word
*/
#define HIBYTE(w)  ( ((w) >> 8) & 0x00ff )
#define LOBYTE(w)  ( (w) & 0x00ff        )

/*
 * Nul-terminator for ASCIIZ strings
*/
#define NUL '\0'
#ifndef EOS
#define EOS NUL
#endif

/*
 * Correct function declarations
*/
#ifdef __cplusplus
	#define EXTERN        extern "C"
#else
	#define EXTERN
#endif

#endif
