/*
 * PB-Lib C/C++ Library Version 0.021
 *
 * Copyright (C) 1995 by Branislav L. Slantchev
 * A product of Silicon Creations, Inc.
 *
 * See the file "copying.pbl" for licensing information.
*/

#ifndef __GDLLIST_H
#define __GDLLIST_H

#ifndef __PBLIB_H
#include <pblib.h>
#endif

#ifdef __cplusplus
	extern "C" {
#endif

/* the following two structures do not contain user-accessible variables  */
/* you should not access them directly but only through the dlist_*() API */
typedef struct _gdlatom{
	struct _gdlatom *prev;
	struct _gdlatom *next;
} dlatom_t;

typedef struct _gdlist{
	word      count;
	dlatom_t *head;
	dlatom_t *tail;
} dlist_t;

/* linkage strategy constants */
#define GDL_START  1      /* links new nodes at the beginning of the list */
#define GDL_END    2      /* appends new nodes to the end of the list     */
#define GDL_SORT   3      /* uses a sort function to determine location   */

/* internal macros to access the header and the data of a node */
#define _dlndata(p)   (  (dlatom_t *)(p) + 1  )
#define _dlnhead(p)   (  (dlatom_t *)(p) - 1  )
#define __dln(p)      (  _dlnhead(p)->next    )
#define __dlp(p)      (  _dlnhead(p)->prev    )

/* for the expected prototypes, see the function prototypes section below */
#define dlist_first(_l)  (void *)( (_l->head) ? _dlndata((_l)->head) : NULL )
#define dlist_last(_l)   (void *)( (_l->tail) ? _dlndata((_l)->tail) : NULL )
#define dlist_next(_pn)  (void *)( __dln(_pn) ? _dlndata(__dln(_pn)) : NULL )
#define dlist_prev(_pn)  (void *)( __dlp(_pn) ? _dlndata(__dlp(_pn)) : NULL )
#define dlist_count(_l)  ( (_l)->count )

dlist_t *dlist_new( void );
void  dlist_free( dlist_t *list, void (*freeNode)(void *) );
int   dlist_link( dlist_t *list, const void *data, size_t width, int where, ... );
void  dlist_unlink( dlist_t *list, void *curNode, void (*freeNode)(void *) );

/*
 * the following functions are implemented as macros above. These are
 * the prototypes for your convenience, so you can see what's expected.
*/
void *__dlist_first( dlist_t *list );
void *__dlist_last( dlist_t *list );
void *__dlist_prev( void *curNode );
void *__dlist_next( void *curNode );
word  __dlist_count( dlist_t *list );

#ifdef __cplusplus
	}
#endif
#endif
