/*
 * PB-Lib C/C++ Library Version 0.021
 *
 * Copyright (C) 1995 by Branislav L. Slantchev
 * A product of Silicon Creations, Inc.
 *
 * See the file "copying.pbl" for licensing information.
*/

#ifndef __SYSUTIL_H
#include <sysutil.h>
#endif

#ifndef PB_SDK
#include <dos.h>
#endif

static int _currentOS = __DOS;

/*
 * Detects the current OS
*/
	int
_dos_detect_os( void )
{
	union REGS r;

	r.x.cx = 0x4445;
	r.x.dx = 0x5351;
	r.x.ax = 0x2b01;
	int86( 0x21, &r, &r );
	if( 0xff == r.h.al ) goto _checkOS2;
	return _currentOS = __DV;

_checkOS2:
	r.h.ah = 0x30;
	int86( 0x21, &r, &r );
	if( 0x0a > r.h.al ) goto _checkWin;
	return _currentOS = __OS2;

_checkWin:
	r.x.ax = 0x4680;
	int86( 0x2f, &r, &r );
	if( 0x0000 == r.x.ax ) return _currentOS = __WIN;
	r.x.ax = 0x1600;
	int86( 0x2f, &r, &r );
	if( 0x00 == r.h.al || 0x80 == r.h.al || 0xff == r.h.al )
		return _currentOS = __DOS;
	else return _currentOS = __WIN;
}

/*
 * Releases a timeslice
*/
	void
_dos_idle( void )
{
	union REGS r;

	switch( _currentOS ){
		case __DV:
			r.x.ax = 0x1000;
			int86( 0x15, &r, &r );
		break;

		case __WIN:
			r.x.ax = 0x1680;
			int86( 0x2f, &r, &r );
		break;

		case __DOS:
		case __OS2:
		default   :
			int86( 0x28, &r, &r );
	}
}
