/*
 * PB-Lib C/C++ Library Version 0.021
 *
 * Copyright (C) 1995 by Branislav L. Slantchev
 * A product of Silicon Creations, Inc.
 *
 * See the file "copying.pbl" for licensing information.
*/

/*
 * The _dos_drvtype() and _dos_drvnum() functions were derived from the
 * Turbo Pascal source for the DrvTypes library. See the file DRIVES.DOC
 * for more information (in the DOCS\PBLIB\CONTRIB) directory.
*/

#ifndef __SYSUTIL_H
#include <sysutil.h>
#endif

#ifndef PB_SDK
#include <dos.h>
#endif

/*
 * returns dtReadOK, dtWriteOK, dtError or dtNotReady, 1 = A, 2 = B
*/
	int
_dos_drvready( int drive )
{
	union  REGS  regs;
	struct SREGS sregs;
	int          i, retval;
	char         buf[512];

	if( dtRemovable != _dos_drvtype(drive) ) return dtError;
	drive--; /* function 0x13 expects numbering A=0, B=1, etc. */

	/* reset the controller (just in case) */
	regs.h.ah = 0x00;
	regs.h.dl = drive;
	int86( 0x13, &regs, &regs );
	if( regs.x.cflag ) return dtError;

	/* see if we're ready for reading */
	for( i = 0; i < 4; ++i ){
		regs.x.ax = 0x0201;
		regs.x.cx = 0x0001;
		regs.h.dh = 0x00;
		regs.h.dl = drive;
		sregs.es = FP_SEG(buf);
		regs.x.bx = FP_OFF(buf);
		int86x( 0x13, &regs, &regs, &sregs );
		if( 0 == regs.x.cflag ){
			retval = dtReadOK;
			goto _checkWrite;
		}
	};
	retval = dtNotReady;
	goto _resetDrive;

	/* see if we're ready for writing */
_checkWrite:
	for( i = 0; i < 4; ++i ){
		regs.x.ax = 0x0301;
		regs.x.cx = 0x0001;
		regs.h.dh = 0x00;
		regs.h.dl = drive;
		sregs.es = FP_SEG(buf);
		regs.x.bx = FP_OFF(buf);
		int86x( 0x13, &regs, &regs, &sregs );
		if( 0 == regs.x.cflag ){
			retval = dtWriteOK;
			goto _resetDrive;
		}
	}

_resetDrive:
	regs.h.ah = 0x00;
	regs.h.dl = drive;
	int86( 0x13, &regs, &regs );

	return retval;
}

/*
 * returns number of recognized valid drives
*/
	int
_dos_drvnum( void )
{
	int i, count;

	for( count = 0, i = 1; i < 26; ++i )
		if( dtError != _dos_drvtype(i) ) count++;
	return count;
}

/*
 * detect drive type, returns dt??? constants. The drive parameter is the
 * drive number to detect, 0 = default, 1 = A, 2 = B, 3 = C, etc.
*/
	int
_dos_drvtype( int drive )
{
	union  REGS  regs;
	struct SREGS sregs;
	char   __dpIOCTL[0x28];

	/* get the default drive if necessary */
	if( 0 == drive ){
		regs.h.ah = 0x19;
		int86( 0x21, &regs, &regs );
		drive = regs.h.al + 1;
	}

	/* check for Diskreet -- skipped */

	/* check for MSCDEX 2.00+ CD-ROM */
	regs.x.ax = 0x1500;
	regs.x.bx = 0;
	int86( 0x2f, &regs, &regs );
	if( 0 == regs.x.bx ) goto _checkSubst;
	regs.x.ax = 0x150b;
	regs.h.ch = 0;
	regs.h.cl = drive - 1; /* CD-ROM drives are somewhat special */
	int86( 0x2f, &regs, &regs );
	if( 0xadad == regs.x.bx && 0 != regs.x.ax ) return dtCDROM;

	/* SUBST'ed drive */
_checkSubst:
	regs.x.ax = 0x4409;
	regs.h.bl = drive;
	int86( 0x21, &regs, &regs );
	if( !regs.x.cflag && regs.h.dh & 0x80 ) return dtSubst;

	/* DoubleSpace compressed drive */
	regs.x.ax = 0x4a11;
	regs.x.bx = 1;
	regs.h.dl = drive - 1;
	int86( 0x2f, &regs, &regs );
	/* is DoubleSpace loaded and host different from compressed? */
	if( 0 != regs.x.ax || regs.h.dl == regs.h.bl ) goto _checkRemote;
	/* bit 7 = 1, DL=compressed, BL = host, assume host is fixed */
	if( regs.h.bl & 0x80 ) goto _checkSStor;
	if( regs.h.dl == drive - 1 ) return dtDblSpace;

_checkSStor:
	/* check for SuperStor -- skipped */

_checkRemote:
	/* check for remote (network) drives */
	regs.x.ax = 0x4409;
	regs.h.bl = drive;
	int86( 0x21, &regs, &regs );
	if( regs.x.cflag ) return dtError;
	if( regs.h.dh & 0x10 ) return dtRemote;

	/* check for Stacker 4 -- skipped */

	/* check for fixed (hard) and removable drives */
	regs.x.ax = 0x4408;
	regs.h.bl = drive;
	int86( 0x21, &regs, &regs );
	if( regs.x.cflag ) return dtError;
	if( 0 == regs.h.al ) return dtRemovable;

	/* check for RAM drives */
	regs.x.ax = 0x440d;
	regs.x.cx = 0x0860;
	sregs.ds = FP_SEG(__dpIOCTL);
	regs.x.dx = FP_OFF(__dpIOCTL);
	int86x( 0x21, &regs, &regs, &sregs );
	if( regs.x.cflag ) return dtRAM; /* RAMDRIVE.SYS and VDSIK.SYS fail */

	/* check for DoubleDisk -- skipped */

	/* check for Bernoully -- skipped */
	regs.h.ah = 0x1c;
	regs.h.dl = drive;
	int86x( 0x21, &regs, &regs, &sregs );

	/*
	 * Note: this check was for 0xFD in the original... why?
	*/
	if( 0xf8 == *(byte *)MK_FP(sregs.ds, regs.x.bx) ) return dtFixed;

	return dtError;
}

