/*
 * PB-Lib C/C++ Library Version 0.021
 *
 * Copyright (C) 1995 by Branislav L. Slantchev
 * A product of Silicon Creations, Inc.
 *
 * See the file "copying.pbl" for licensing information.
*/

#ifndef __STRLIB_H
#include <strlib.h>
#endif

/*
 * Concatenates multiple strings, caller must free the resulting buffer.
*/
	char*
strvcat( char *s, ... )
{
	   char *p, *ptr;
	 size_t  len;
	va_list  arg;

	if( s ) len = strlen(s);
	else len = 0;

	va_start(arg, s);
	while( NULL != (p = va_arg( arg, char* )) )
		len += strlen(p);
	va_end(arg);

	if( NULL == (ptr = (char *)malloc(len + 1)) ) return NULL;

	if( s ) strcpy(ptr, s);
	else ptr[0] = EOS;

	va_start(arg, p);
	while( NULL != (p = va_arg( arg, char* )) )
		strcat( ptr, p );
	va_end(arg);

	return ptr;
}
