/*
 * PB-Lib C/C++ Library Version 0.021
 *
 * Copyright (C) 1995 by Branislav L. Slantchev
 * A product of Silicon Creations, Inc.
 *
 * See the file "copying.pbl" for licensing information.
*/

#ifndef __STRLIB_H
#include <strlib.h>
#endif

/*
 * strichr: searches for a character c in string s, case insensitive
*/
    char*
strichr( const char *s, int c )
{
    const char *p;
	int ch = toupper(c);

	/* special case with the terminator char */
	if( 0 == ch ) return &((char *)s)[strlen(s)];

	/* do a normal search */
	for( p = s; *p; ++p )
		if( toupper(*p) == ch ) return (char *)p;

	return NULL;
}
