/*
 * PB-Lib C/C++ Library Version 0.021
 *
 * Copyright (C) 1995 by Branislav L. Slantchev
 * A product of Silicon Creations, Inc.
 *
 * See the file "copying.pbl" for licensing information.
*/

#ifndef __STRLIB_H
#include <strlib.h>
#endif

	char*
stradd( char *dest, const char *s1, const char *s2 )
{
	size_t len1 = strlen(s1);
	size_t len2 = strlen(s2);
	size_t diff = len1 - len2, i;
	const char *p;
	char *buf;
	 int inc;

	if( len2 > len1 ){
		SWAP( len1, len2, size_t );
		SWAP( s1, s2, const char * );
		diff = -diff;
	}
	if( NULL == (buf = (char *)malloc( len1 + 2 )) ){
		dest[0] = EOS;
		return NULL;
	}
	memset( dest, EOS, len1 + 2 );
	memset( buf, '0', diff );
	strcpy( &buf[diff], s2 );

	for( i = inc = 0, len1--, p = &s1[len1]; p >= s1; --len1, --p, ++i ){
		int val = inc + (*p + buf[len1] - 96);
		if( 9 < val ){
			inc = 1;
			val %= 10;
		}
		else inc = 0;
		dest[i] = val + '0';
	}
	if( inc ) dest[i] = '1';

	free( buf );
	return strrev(dest);
}

