/*
 * PB-Lib C/C++ Library Version 0.021
 *
 * Copyright (C) 1995 by Branislav L. Slantchev
 * A product of Silicon Creations, Inc.
 *
 * See the file "copying.pbl" for licensing information.
*/

#ifndef __PROUTIL_H
#include <proutil.h>
#endif

static int __readUser( long, void *, size_t, const char * );
static int __writeUser( long, const void *, size_t, const char * );

/*
 * reads a record from a userbase file
*/
	int
__readUser( long recNum, void *rec, size_t width, const char *filename )
{
	return ReadFileRec( _mkUserPath(filename), recNum + 1L,	rec, width );
}

/*
 * writes a record to a userbase file. If recNum is too high, it is appended
 * this function always creates a backup copy of the file
*/
	int
__writeUser( long recNum, const void *rec,
			 size_t width, const char *filename )
{
	UserBackup( filename );
	return WriteFileRec( _mkUserPath(filename), recNum + 1L, rec, width );
}


/*
 * writes an entry to the USERS.BBS file
*/
	int
WriteUserBBS( const USERS *rec, long recNum )
{
	return __writeUser( recNum, rec, sizeof(USERS), fnUSERS );
}

/*
 * writes an entry to the USERSPB.BBS file
*/
	int
WriteUserPB( const USERSPB *rec, long recNum )
{
	return __writeUser( recNum, rec, sizeof(USERSPB), fnUSERSPB );
}

/*
 * writes an entry to the USERSXI.BBS file
*/
	int
WriteUserXI( const USERSXI *rec, long recNum )
{
	return __writeUser( recNum, rec, sizeof(USERSXI), fnUSERSXI );
}

/*
 * writes an entry to the USERSIDX.BBS file
*/
	int
WriteUserIDX( const USERSIDX *rec, long recNum )
{
	return __writeUser( recNum, rec, sizeof(USERSIDX), fnUSERSIDX );
}

/*
 * reads an entry from the USERS.BBS file
*/
	int
ReadUserBBS( USERS *rec, long recNum )
{
	return __readUser( recNum, rec, sizeof(USERS), fnUSERS );
}

/*
 * reads an entry from the USERSPB.BBS file
*/
	int
ReadUserPB( USERSPB *rec, long recNum )
{
	return __readUser( recNum, rec, sizeof(USERSPB), fnUSERSPB );
}

/*
 * reads an entry from the USERSXI.BBS file
*/
	int
ReadUserXI( USERSXI *rec, long recNum )
{
	return __readUser( recNum, rec, sizeof(USERSXI), fnUSERSXI );
}

/*
 * reads an entry from the USERSIDX.BBS file
*/
	int
ReadUserIDX( USERSIDX *rec, long recNum )
{
	return __readUser( recNum, rec, sizeof(USERSIDX), fnUSERSIDX );
}
