/*
 * PB-Lib C/C++ Library Version 0.021
 *
 * Copyright (C) 1995 by Branislav L. Slantchev
 * A product of Silicon Creations, Inc.
 *
 * See the file "copying.pbl" for licensing information.
*/

#ifndef __PROUTIL_H
#include <proutil.h>
#endif

#ifndef __CRC32_H
#include <crc32.h>
#endif

#ifndef PB_SDK
#include <stdio.h>
#include <string.h>
#endif

static long __findUser( const char *user, bool name );

/*
 * fills a USERSIDX structure with user index info
*/
	void
MakeUserIndex( USERSIDX *rec, const char *name, const char *alias )
{
	dword crc32;
	char  buf[BUFSIZ];

	strcpy( buf, name );
	crc32 = bufCRC32( strupr(buf), strlen(buf) );
	rec->nameCRC32 = ~crc32;
	strcpy( buf, alias );
	crc32 = bufCRC32( strupr(buf), strlen(buf) );
	rec->aliasCRC32 = ~crc32;
}

/*
 * finds a record, by name or alias, record numbering starts at zero!
*/
	long
__findUser( const char *data, bool name )
{
	FILE     *fp = usrfopen( fnUSERSIDX, "rb" );
	long      retval = -1L;
	dword     crc32;
	char      buf[BUFSIZ];
	USERSIDX  rec;

	if( fp ){
		setvbuf( fp, NULL, _IOFBF, 0x4000 );
		strcpy( buf, data );
		crc32 = ~bufCRC32( strupr(buf), strlen(buf) );
		do{
			if( 1 != fread(&rec, sizeof(USERSIDX), 1, fp) ) break;
			if( feof(fp) ) break;
			if( crc32 == (name ? rec.nameCRC32 : rec.aliasCRC32) ){
				retval = l_div(ftell(fp), (long)sizeof(USERSIDX)) - 1L;
				break;
			}
		}while( 1 );
		fclose(fp);
	}
	return retval;
}


/*
 * locates a record by name
*/
	long
FindUserName( const char *name )
{
	return __findUser( name, TRUE );
}

/*
 * locates a record by alias
*/
	long
FindUserAlias( const char *alias )
{
	return __findUser( alias, FALSE );
}

#ifdef DEBUG_USERSIDX
#include <fail.h>
#include <getopt.h>
#include <string.h>
#include <fsys.h>

	int
main( int argc, char *argv[] )
{
	long recNum;
	int  opt;

	if( 1 == argc ) fail( "%s: usage: -a\"alias\" | -n\"name\"",
		strlwr( basename(*argv) ) );
	while( EOF != (opt = getopt(argc, argv, "a:n:")) ){
		printf( "\r                                     "
				"                                       \r" );
		switch( opt ){
			case 'a':
				printf( "searching for alias '%s'...", optarg );
				recNum = FindUserAlias(optarg);
			break;
			case 'n':
				printf( "searching for name '%s'...", optarg );
				recNum = FindUserName(optarg);
			break;
			default : fail( "aborting..." );
		}
		printf( "\r                                     "
				"                                       \r" );
		if( -1L == recNum )
			printf( "user %s '%s' could not be located\n",
				(opt == 'a') ? "alias" : "name", optarg );
		else
			printf( "found %s '%s', record number %ld\n",
				('a' == opt) ? "alias" : "name", optarg, recNum );
	}
	return 0;
}

#endif
