/*
 * PB-Lib C/C++ Library Version 0.021
 *
 * Copyright (C) 1995 by Branislav L. Slantchev
 * A product of Silicon Creations, Inc.
 *
 * See the file "copying.pbl" for licensing information.
*/

#ifndef __PROUTIL_H
#include <proutil.h>
#endif

/*
 
  Public functions exported by this module.
 
*/

/*
 * returns number of records in the userbase (uses USERS.BBS)
*/
	long
GetNumUsers( void )
{
	return NumFileRecs( _mkUserPath(fnUSERS), sizeof(USERS) );
}


/*
 * the PEX mode (SDK) has the WriteUser() and ReadUser() functions anyway.
*/
#ifndef PB_SDK

#ifndef __STRLIB_H
#include <strlib.h>
#endif
#ifndef __CRC32_H
#include <crc32.h>
#endif

/*
 * global variables local to this module
*/
static USERS   __ra;      /* holds the structure for I/O for USERS.BBS    */
static USERSPB __pb;      /* holds the structure for I/O for USERPB.BBS   */

/*
 * local function prototypes
*/
static void  _ra2pbDate( byte *pb, const char *ra );
static void  _ra2pbTime( byte *pb, const char *ra );
static void  _pb2raDate( char *ra, const byte *pb );
static void  _pb2raTime( char *ra, const byte *pb );
static dword _setUserAccess( void );
static void  _cvtUserAccess( dword flags );
static dword _setUserAttrib( void );
static void  _cvtUserAttrib( dword flags );

/*
 * constructs a USER_REC record from the userbase
*/
	int
ReadUser( USER_REC *rec, long recNum )
{
	/* load the two big records from USERS.BBS and USERSPB.BBS */
	if( -1 == ReadUserBBS(&__ra, recNum) ||
		-1 == ReadUserPB(&__pb, recNum) ){

		return -1;
	}

	rec->record = recNum;

	/*
	 * get the information from the ProBoard structure
	*/
	strcpy( rec->name, __pb.name );
	strcpy( rec->country, __pb.country );
	strcpy( rec->state, __pb.state );
	strcpy( rec->faxPhone, __pb.faxPhone );
	strcpy( rec->passWord, __pb.passWord );
	strcpy( rec->language, __pb.language );
	memcpy( rec->lastPwdChange, __pb.lastPwdChange, sizeof(DateType) );
	memcpy( rec->lastNewFilesCheck, __pb.lastNewFilesCheck, sizeof(DateType));
	memcpy( rec->tbTimePayback, __pb.tbTimePayback, sizeof(DateType) );
	memcpy( rec->tbKbPayback, __pb.tbKbPayback, sizeof(DateType) );
	memcpy( rec->tbLastUsed, __pb.tbLastUsed, sizeof(DateType) );
	memcpy( rec->mailCheckBoards, __pb.mailCheckBoards, 125 );
	rec->logLevel = __pb.logLevel;
	rec->tbTimeBalance = __pb.tbTimeBalance;
	rec->tbKbBalance = __pb.tbKbBalance;
	rec->tbTimeWithdrawn = __pb.tbTimeWithdrawn;
	rec->tbKbWithdrawn = __pb.tbKbWithdrawn;
	rec->tbTimeDeposited = __pb.tbTimeDeposited;
	rec->tbKbDeposited = __pb.tbKbDeposited;
	rec->tbTimeLoaned = __pb.tbTimeLoaned;
	rec->tbKbLoaned = __pb.tbKbLoaned;
	rec->expLevel = __pb.expLevel;
	rec->expFlagsOn = __pb.expFlagsOn;
	rec->expFlagsOff = __pb.expFlagsOff;
	rec->totalTimeUsed = __pb.totalTimeUsed;
	rec->qwkMaxMsgsPerArea = __pb.qwkMaxMsgsPerArea;
	rec->qwkMaxMsgs = __pb.qwkMaxMsgs;
	rec->qwkArchiver = __pb.qwkArchiver;
	rec->ripFont = __pb.ripFont;
	rec->checkMail = __pb.checkMail;
	rec->checkNewFiles = __pb.checkNewFiles;

	/*
	 * get the info from the RA structure
	*/

	/* if alias is the same as the name, it won't be in the USERS.BBS */
	/* but we must set the alias to the name since PB does that too.  */
	if( 0 != __ra.alias[0] ) strfmpas( rec->alias, __ra.alias );
	else strcpy( rec->alias, rec->name );

	strfmpas( rec->city, __ra.city );
	strfmpas( rec->company, __ra.company );
	strfmpas( rec->address1, __ra.address1 );
	strfmpas( rec->address2, __ra.address2 );
	strfmpas( rec->address3, __ra.address3 );
	strfmpas( rec->comment, __ra.comment );
	strfmpas( rec->forwardTo, __ra.forwardTo );
	strfmpas( rec->voicePhone, __ra.voicePhone );
	strfmpas( rec->dataPhone, __ra.dataPhone );
	memcpy( rec->combinedBoards, (byte *)__ra.combinedBoards, 125 );
	rec->passWordCRC = __ra.passWordCRC;
	rec->level = __ra.level;
	rec->sex = __ra.sex;
	rec->dateFormat = __ra.dateFormat;
	rec->defaultProtocol = __ra.defaultProtocol;
	rec->screenWidth = __ra.screenWidth;
	rec->screenLength = __ra.screenLength;
	rec->timeUsed = (long)__ra.timeUsed;
	rec->timesCalled = __ra.timesCalled;
	rec->numDownloads = __ra.numDownloads;
	rec->kbDownloaded = __ra.kbDownloaded;
	rec->numUploads = __ra.numUploads;
	rec->kbUploaded = __ra.kbUploaded;
	rec->msgsPosted = __ra.msgsPosted;
	rec->kbToday = __ra.kbToday;
	rec->credit = __ra.credit;
	rec->pending = __ra.pending;
	rec->fileArea = __ra.fileArea;
	rec->msgArea = __ra.msgArea;
	rec->highMsgRead = __ra.highMsgRead;
	rec->fileGroup = __ra.fileGroup;
	rec->msgGroup = __ra.msgGroup;
	rec->aFlags = _setUserAccess();
	_ra2pbDate( rec->expDate, __ra.subDate );
	_ra2pbDate( rec->birthDate, __ra.birthDate );
	_ra2pbDate( rec->lastDate, __ra.lastDate );
	_ra2pbTime( rec->lastTime, __ra.lastTime );
	_ra2pbDate( rec->firstDate, __ra.firstDate );

	/*
	 * from both structures
	*/
	rec->uFlags = _setUserAttrib();
	return 0;
}


/*
 * The SDK interface-like function (no return value)
*/
	void
WriteUser( const USER_REC *rec )
{
	__writeUserRec( rec );
}

/*
 * writes a USER_REC entry to the userbase
*/
	int
__writeUserRec( const USER_REC *rec )
{
	USERSXI  usrXI;             /* temporary variable to write to USERSXI */
	USERSIDX usrIDX;            /* temporary variable to construct index  */
	int      retval = 0;        /* return status of the write functions   */
	char     crcBuf[16];        /* for calculating the password CRC value */

	/*
	 * convert to the PB structure for the USERSPB.BBS file
	*/
	strcpy( __pb.name, rec->name );
	strcpy( __pb.country, rec->country );
	strcpy( __pb.state, rec->state );
	strcpy( __pb.faxPhone, rec->faxPhone );
	strcpy( __pb.passWord, rec->passWord );
	strcpy( __pb.language, rec->language );
	memcpy( __pb.lastPwdChange, rec->lastPwdChange, sizeof(DateType) );
	memcpy( __pb.lastNewFilesCheck, rec->lastNewFilesCheck, sizeof(DateType));
	memcpy( __pb.tbTimePayback, rec->tbTimePayback, sizeof(DateType) );
	memcpy( __pb.tbKbPayback, rec->tbKbPayback, sizeof(DateType) );
	memcpy( __pb.tbLastUsed, rec->tbLastUsed, sizeof(DateType) );
	memcpy( __pb.mailCheckBoards, rec->mailCheckBoards, 125 );
	__pb.logLevel = rec->logLevel;
	__pb.tbTimeBalance = rec->tbTimeBalance;
	__pb.tbKbBalance = rec->tbKbBalance;
	__pb.tbTimeWithdrawn = rec->tbTimeWithdrawn;
	__pb.tbKbWithdrawn = rec->tbKbWithdrawn;
	__pb.tbTimeDeposited = rec->tbTimeDeposited;
	__pb.tbKbDeposited = rec->tbKbDeposited;
	__pb.tbTimeLoaned = rec->tbTimeLoaned;
	__pb.tbKbLoaned = rec->tbKbLoaned;
	__pb.expLevel = rec->expLevel;
	__pb.expFlagsOn = rec->expFlagsOn;
	__pb.expFlagsOff = rec->expFlagsOff;
	__pb.totalTimeUsed = rec->totalTimeUsed;
	__pb.qwkMaxMsgsPerArea = rec->qwkMaxMsgsPerArea;
	__pb.qwkMaxMsgs = rec->qwkMaxMsgs;
	__pb.qwkArchiver = rec->qwkArchiver;
	__pb.ripFont = rec->ripFont;
	__pb.checkMail = rec->checkMail;
	__pb.checkNewFiles = rec->checkNewFiles;

	/*
	 * convert to the RA structure for the USERS.BBS file
	*/

	/* if the alias is same as the name, don't store it in  */
	/* USERS.BBS. The comparison _is_ case-sensitive though */
	if( !strcmp( rec->name, rec->alias ) ) __ra.alias[0] = 0;
	else strtopas( __ra.alias, rec->alias );

	memcpy( (byte *)__ra.combinedBoards, rec->combinedBoards, 125 );
	memset( &((byte *)__ra.combinedBoards)[125], 0, 275 );
	strtopas( __ra.city, rec->city );
	strtopas( __ra.company, rec->company );
	strtopas( __ra.address1, rec->address1 );
	strtopas( __ra.address2, rec->address2 );
	strtopas( __ra.address3, rec->address3 );
	strtopas( __ra.comment, rec->comment );
	strtopas( __ra.forwardTo, rec->forwardTo );
	strtopas( __ra.voicePhone, rec->voicePhone );
	strtopas( __ra.dataPhone, rec->dataPhone );
	strtopas( __ra.name, rec->name );
	_pb2raDate( __ra.birthDate, rec->birthDate );
	_pb2raDate( __ra.lastDate, rec->lastDate );
	_pb2raTime( __ra.lastTime, rec->lastTime );
	_pb2raDate( __ra.firstDate, rec->firstDate );
	_pb2raDate( __ra.subDate, rec->expDate );
	_cvtUserAccess( rec->aFlags );
	strcpy( crcBuf, rec->passWord );
	__ra.passWordCRC = ~bufCRC32( strupr(crcBuf), strlen(crcBuf) );
	__ra.sex = rec->sex;
	__ra.dateFormat = rec->dateFormat;
	__ra.defaultProtocol = rec->defaultProtocol;
	__ra.screenWidth = rec->screenWidth;
	__ra.screenLength = rec->screenLength;
	__ra.timeUsed = (word)rec->timeUsed;
	__ra.timesCalled = rec->timesCalled;
	__ra.numDownloads = rec->numDownloads;
	__ra.kbDownloaded = rec->kbDownloaded;
	__ra.numUploads = rec->numUploads;
	__ra.kbUploaded = rec->kbUploaded;
	__ra.msgsPosted = rec->msgsPosted;
	__ra.level = rec->level;
	__ra.kbToday = rec->kbToday;
	__ra.credit = rec->credit;
	__ra.pending = rec->pending;
	__ra.fileArea = rec->fileArea;
	__ra.msgArea = rec->msgArea;
	__ra.highMsgRead = rec->highMsgRead;
	__ra.fileGroup = rec->fileGroup;
	__ra.msgGroup = rec->msgGroup;

	/*
	 * to both structures
	*/
	_cvtUserAttrib( rec->uFlags );

	/*
	 * update USERSXI.BBSand USERSIDX structures
	*/
	memset( &usrXI, 0, sizeof(USERSXI) );
	MakeUserIndex( &usrIDX, rec->name, rec->alias );

	/*
	 * do the actual writes to the userbase
	*/
	if( -1 == WriteUserBBS(&__ra, rec->record) )   retval = -1;
	if( -1 == WriteUserPB(&__pb, rec->record) )    retval = -1;
	if( -1 == WriteUserXI(&usrXI, rec->record) )   retval = -1;
	if( -1 == WriteUserIDX(&usrIDX, rec->record) ) retval = -1;
	return retval;
}

/*
 
  Functions local to this module.
 
*/

/*
 * converts RA date format to PB style
*/
	void
_ra2pbDate( byte *pb, const char *ra )
{
	char date[9];
	int mon, day, yr;

	strfmpas( date, ra );
	sscanf( date, "%2d-%2d-%2d", &mon, &day, &yr );
	pb[0] = (byte)day; pb[1] = (byte)mon; pb[2] = (byte)yr;
}

/*
 * converts PB date format to RA style
*/
	void
_pb2raDate( char *ra, const byte *pb )
{
	char buf[9];

	sprintf( buf, "%02d-%02d-%02d", (int)pb[1], (int)pb[0], (int)pb[2] );
	strtopas( ra, buf );
}

/*
 * converts RA time format to PB style
*/
	void
_ra2pbTime( byte *pb, const char *ra )
{
	char t[6];
	int hour, min;

	strfmpas( t, ra );
	sscanf( t, "%2d:%2d", &hour, &min );
	pb[0] = (byte)hour; pb[1] = (byte)min; pb[2] = 0;
}

/*
 * converts PB time format to RA style
*/
	void
_pb2raTime( char *ra, const byte *pb )
{
	char buf[9];
	sprintf( buf, "%02d:%02d", (int)pb[0], (int)pb[1] );
	strtopas( ra, buf );
}

/*
 * sets the user access flags, __ra must contain valid data
*/
	dword
_setUserAccess( void )
{
	dword flags = 0L;
	 int  i;

	for( i = 0; i < 32; ++i ){
		if( __ra.aFlags[i >> 3] & (1 << (i & 0x07)) )
			flags |= ul_shl(1L, 31 - i);
	}
	return flags;
}

/*
 * converts the user access flags, modifes __ra
*/
	void
_cvtUserAccess( dword flags )
{
	int i;

	memset( __ra.aFlags, 0, 4 );
	for( i = 0; i < 32; ++i ){
		if( flags & ul_shl(1L, 31 - i) )
			__ra.aFlags[i >> 3] |= (1 << (i & 0x07));
	}
}

/*
 * sets the user attributes (__pb and __ra MUST contain valid info)
*/
	dword
_setUserAttrib( void )
{
	dword flags = 0L;

	if( __ra.attribute1 & RAF1_DELETED    ) flags |= UFLAG_DELETED;
	if( __ra.attribute1 & RAF1_ANSI       ) flags |= UFLAG_ANSI;
	if( __ra.attribute1 & RAF1_PAUSE      ) flags |= UFLAG_PAUSE;
	if( __ra.attribute1 & RAF1_CLEAR      ) flags |= UFLAG_CLEAR;
	if( __ra.attribute1 & RAF1_FSED       ) flags |= UFLAG_FSED;
	if( __ra.attribute1 & RAF1_NOKILL     ) flags |= UFLAG_NOKILL;
	if( __ra.attribute1 & RAF1_IGNORE     ) flags |= UFLAG_IGNORE;
	if( __ra.attribute1 & RAF1_QUIET      ) flags |= UFLAG_QUIET;
	if( __ra.attribute2 & RAF2_HOTKEYS    ) flags |= UFLAG_HOTKEYS;
	if( __ra.attribute2 & RAF2_HIDDEN     ) flags |= UFLAG_HIDDEN;
	if( __ra.attribute2 & RAF2_AVATAR     ) flags |= UFLAG_AVATAR;
	if( __ra.attribute2 & RAF2_GUEST      ) flags |= UFLAG_GUEST;
	if( __ra.attribute2 & RAF2_PAGEPRI    ) flags |= UFLAG_PAGEPRI;
	if( __pb.uFlags     & PBUF_NOIBM      ) flags |= UFLAG_NOIBM;
	if( __pb.uFlags 	& PBUF_ATTEN      ) flags |= UFLAG_ATTEN;
	if( __pb.uFlags 	& PBUF_NOTOPS     ) flags |= UFLAG_NOTOPS;
	if( __pb.uFlags 	& PBUF_AVTPLUS    ) flags |= UFLAG_AVTPLUS;
	if( __pb.uFlags 	& PBUF_LOCALONLY  ) flags |= UFLAG_LOCALONLY;
	if( __pb.uFlags 	& PBUF_MULTILOGIN ) flags |= UFLAG_MULTILOGIN;
	if( __pb.uFlags 	& PBUF_FREECHAT   ) flags |= UFLAG_FREECHAT;
	if( __pb.uFlags 	& PBUF_NORIP      ) flags |= UFLAG_NORIP;

	return flags;
}

/*
 * sets the attribute? and uFlags values in __pb and __ra
*/
	void
_cvtUserAttrib( dword flags )
{
	__ra.attribute1 = __ra.attribute2 = 0;
	__pb.uFlags = 0L;

	if( flags & UFLAG_DELETED    )  __ra.attribute1 |= RAF1_DELETED;
	if( flags & UFLAG_ANSI       )  __ra.attribute1 |= RAF1_ANSI;
	if( flags & UFLAG_PAUSE      )  __ra.attribute1 |= RAF1_PAUSE;
	if( flags & UFLAG_CLEAR      )  __ra.attribute1 |= RAF1_CLEAR;
	if( flags & UFLAG_FSED       )  __ra.attribute1 |= RAF1_FSED;
	if( flags & UFLAG_NOKILL     )  __ra.attribute1 |= RAF1_NOKILL;
	if( flags & UFLAG_IGNORE     )  __ra.attribute1 |= RAF1_IGNORE;
	if( flags & UFLAG_QUIET      )  __ra.attribute1 |= RAF1_QUIET;
	if( flags & UFLAG_HOTKEYS    )  __ra.attribute2 |= RAF2_HOTKEYS;
	if( flags & UFLAG_HIDDEN     )  __ra.attribute2 |= RAF2_HIDDEN;
	if( flags & UFLAG_AVATAR     )  __ra.attribute2 |= RAF2_AVATAR;
	if( flags & UFLAG_GUEST      )  __ra.attribute2 |= RAF2_GUEST;
	if( flags & UFLAG_PAGEPRI    )  __ra.attribute2 |= RAF2_PAGEPRI;
	if( flags & UFLAG_NOIBM      )  __pb.uFlags     |= PBUF_NOIBM;
	if( flags & UFLAG_ATTEN      )  __pb.uFlags     |= PBUF_ATTEN;
	if( flags & UFLAG_NOTOPS     )  __pb.uFlags     |= PBUF_NOTOPS;
	if( flags & UFLAG_AVTPLUS    )  __pb.uFlags     |= PBUF_AVTPLUS;
	if( flags & UFLAG_LOCALONLY  )  __pb.uFlags     |= PBUF_LOCALONLY;
	if( flags & UFLAG_MULTILOGIN )  __pb.uFlags     |= PBUF_MULTILOGIN;
	if( flags & UFLAG_FREECHAT   )  __pb.uFlags     |= PBUF_FREECHAT;
	if( flags & UFLAG_NORIP      )  __pb.uFlags     |= PBUF_NORIP;
}

#endif
