/*
 * PB-Lib C/C++ Library Version 0.021
 *
 * Copyright (C) 1995 by Branislav L. Slantchev
 * A product of Silicon Creations, Inc.
 *
 * See the file "copying.pbl" for licensing information.
*/

#ifndef __PROUTIL_H
#include <proutil.h>
#endif

#ifndef PB_SDK
	#include <stdio.h>
	#include <stdarg.h>
	#include <io.h>
	#ifdef _MSC_VER
		#include <sys/types.h>
	#endif
	#include <sys/stat.h>
	#include <string.h>
	#include <stdlib.h>
#endif

static char _userd_path[MAXPATH] = "\0";

/*
 * Creates a USERDOES-compatible drop file.
 * On success, returns 0, otherwise: -1
*/
	int
userd_creat( const char *fmt, ... )
{
	va_list arg;
	int uHnd;
	char buf[BUFSIZ];

#ifdef PB_SDK
	sprintf( _userd_path, "%s\\USERDOES.%d", SysPath, NodeNumber );
#else
	char *p = getenv( "PROBOARD" );
	if( !p ) strcpy( _userd_path, "USERDOES.1" );
	else strcat( strcpy(_userd_path,p), "\\USERDOES.1" );
#endif

	va_start( arg, fmt );
	vsprintf( buf, fmt, arg );
	va_end( arg );

	/* line should not be longer than 22 characters */
	buf[USERDOES_LEN] = '\0';

	if( -1 == (uHnd = creat( _userd_path, S_IWRITE )) ){
		_userd_path[0] = '\0';
		return -1;
	}

	if( -1 == write( uHnd, buf, USERDOES_LEN ) ){
		_userd_path[0] = '\0';
		close( uHnd );
		return -1;
	}

	close( uHnd );
	return 0;
}

/*
 * Removes the dropfile created by userd_creat
*/
	int
userd_unlink( void )
{
	if( '\0' == _userd_path[0] ) return 0;
	return unlink( _userd_path );
}
