/*
 * PB-Lib C/C++ Library Version 0.021
 *
 * Copyright (C) 1995 by Branislav L. Slantchev
 * A product of Silicon Creations, Inc.
 *
 * See the file "copying.pbl" for licensing information.
*/

#ifndef __PROUTIL_H
#include <proutil.h>
#endif

#ifndef PB_SDK
#include <time.h>
#include <assert.h>
#include <string.h>
#endif

#define UF_LINE 255  /* maximum characters per line to read (until CR) */

static FILE *__ulfp = NULL;


/*
 * opens the UPLOAD log file (if it exists) and returns first record from it
 * returns 0 on success and -1 on error or no records found.
*/
	int
ulGetFirst( upload_t *rec )
{
	assert(NULL == __ulfp);
	__ulfp = pbfopen( fnUPLOADLOG, "r" );
	if( __ulfp ) return ulGetNext( rec );
	else return -1;
}


/*
 * reads next record from UPLOAD log, if no more, closes the file. An
 * assertion error will be produced if called before ulGetFirst() or if
 * called after ulGetFirst() returned an error, or after ulGetNext()
 * returned no more records. Returns 0 on success or -1 on end of file.
*/
	int
ulGetNext( upload_t *rec )
{
	int   i;
	char  buf[UF_LINE + 1], mon[4];
	static char *monStr[12] = { "Jan", "Feb", "Mar", "Apr", "May",
								"Jun", "Jul", "Aug", "Sep", "Oct",
								"Nov", "Dec" };

	/*
	 * read the next line (including terminating CR), see if no more lines
	*/
	assert( NULL != __ulfp );
	fgets( buf, UF_LINE, __ulfp );
	if( feof(__ulfp) ){
		fclose(__ulfp);
		__ulfp = NULL;
		return -1;
	}

	/* parse the fixed format into a tm structure */
	memset( &rec->date, 0, sizeof(struct tm) );
	sscanf( buf, "%2d-%3s-%2d %2d:%2d:%2d %*6c %*2c %12s",
			&rec->date.tm_mday, mon, &rec->date.tm_year, &rec->date.tm_hour,
			&rec->date.tm_min, &rec->date.tm_sec, rec->file );

	/* names can contain whitespace, so we just copy and get rid of the CR */
	strcpy( rec->name, &buf[46] );
	rec->name[strlen(rec->name) - 1] = EOS;

	/* set up the month depending on the abbreviated string */
	for( i = 0; i < 12; ++i ){
		if( !strcmp(monStr[i], mon) ){
			rec->date.tm_mon = i;
			break;
		}
	}

	/* adjust all other fields in the tm structure */
	mktime( &rec->date );
	return 0;
}

#undef UF_LINE
