/*
 * PB-Lib C/C++ Library Version 0.021
 *
 * Copyright (C) 1995 by Branislav L. Slantchev
 * A product of Silicon Creations, Inc.
 *
 * See the file "copying.pbl" for licensing information.
*/

#ifndef PB_SDK
#error This function only works with the SDK!
#endif

#ifndef __PROUTIL_H
#include <proutil.h>
#endif

/*
 * checks CurUser's permissions for access to 'level' with 'flags' and
 * 'flagsNot'. The difference between this functions and SDK's CheckAccess()
 * is the flagsNot support for inverted flags. If you set flagsNot to 0,
 * they will simply be ignored.
 *
 * Returns TRUE if the user has access and FALSE if not
*/
	bool
hasAccess( word level, dword flags, dword flagsNot )
{
	if( CheckAccess(level, flags) && (0L == (CurUser->aFlags & flagsNot)) )
		return TRUE;
	return FALSE;
}