/*
 * PB-Lib C/C++ Library Version 0.021
 *
 * Copyright (C) 1995 by Branislav L. Slantchev
 * A product of Silicon Creations, Inc.
 *
 * See the file "copying.pbl" for licensing information.
*/

#ifndef __PROUTIL_H
#include <proutil.h>
#endif

#ifdef __TFRAME_NOMAC

/*
 * TimeFrame for certain day, hours are in 6 bytes, 48 bits for
 * half-hour segments. For example, from 0:00 to 0:30, bit 1 of byte 1,
 * from 0:30 to 1:00, bit 2 of byte 1, etc. Days start from Monday = 0
 * and go to Sunday = 6.
*/

/*
 * checks if timeframe is enabled for given time of struct tm type
 * this structure needs to be filled by the caller with the desired time
 * and day of week information in tm-compatible format, i.e., the day of
 * week starts at Sunday = 0.
*/
	bool
tfGetEnable( TimeFrame tFrame, const struct tm *trec )
{
	/* Sunday = 0, we need Monday = 0, Sunday = 6 */
	byte day = trec->tm_wday;
	if( 0 == day ) day = 6;
	else day--;

	/*
	 * the day starts at Monday = 0 and ends with Sunday = 6. The half-hour
	 * byte is in hour / 4, the bit we need to check is in hour modulus
	 * 4 (ranging from 0 to 3) multiplied by 2, which gets us the range of
	 * halves, next we need to add one if it's past the 30th minute.
	*/
	return BOOL(
		tFrame[day][trec->tm_hour >> 2] &
		(1 << (((trec->tm_hour % 4) << 1) + ((trec->tm_min > 30) ? 1 : 0)) )
	);
}

#endif
