/*
 * PB-Lib C/C++ Library Version 0.021
 *
 * Copyright (C) 1995 by Branislav L. Slantchev
 * A product of Silicon Creations, Inc.
 *
 * See the file "copying.pbl" for licensing information.
*/

#ifndef __PROUTIL_H
#include <proutil.h>
#endif

/*
 * reads a message group definition
*/
	int
ReadMsgGroup( int recNum, MSGROUP *rec )
{
	return ReadFileRec( _mkSysPath(fnMGROUPS), (long)recNum,
						rec, sizeof(MSGROUP) );
}

/*
 * returns number of available message groups
*/
	int
NumMsgGroups( void )
{
	return (int)NumFileRecs( _mkSysPath(fnMGROUPS), sizeof(MSGROUP) );
}

/* only in offline mode, the SDK has these already! */
#ifndef PB_SDK
/*
 * reads info about a message area
*/
	bool
ReadMsgArea( int recNum, MSGAREA *rec )
{
	return (0 == ReadFileRec(_mkSysPath(fnMESSAGES), (long)recNum,
				rec, sizeof(MSGAREA)) ) ? TRUE : FALSE;
}

/*
 * returns number of message areas
*/
	int
NumMsgAreas( void )
{
	return (int)NumFileRecs( _mkSysPath(fnMESSAGES), sizeof(MSGAREA) );
}

#endif
