/*
 * PB-Lib C/C++ Library Version 0.021
 *
 * Copyright (C) 1995 by Branislav L. Slantchev
 * A product of Silicon Creations, Inc.
 *
 * See the file "copying.pbl" for licensing information.
*/

#ifndef __PROUTIL_H
#include <proutil.h>
#endif

#ifndef __TIMER_H
#include <timer.h>
#endif

#ifndef PB_SDK
	#include <conio.h>
	#define PeekChar()            ( kbhit() ? getch() : 0 )
	#define ExternalInput()       __kbExternalInput()
	#define InstallHandler(a,b)
	#define RemoveHandler(a,b)
#else
	static int  _kbdHandler( KEY key );
#endif

typedef struct{
	int  code;                      /* key code                            */
	bool local;                     /* TRUE if key was local, FALSE=remote */
} __keyBuff;

#define ANSI_ESCAPE  0x1b           /* ESCAPE starts ANSI sequences        */
#define ANSI_SEQ     0x5b           /* '[' should be next character        */

#define _kbdEmpty()  BOOL(_kbdHead == _kbdTail)

static int _kbdHead, _kbdTail;        /* circular queue head/tail pointers */
static __keyBuff _KeyBuf[MAX_KBDBUF]; /* keyboard buffer, circular queue   */

static void _kbdGet( __keyBuff *key );
static void _kbdPut( int code, bool local );
static void _kbdWaitKey( void );

#ifdef PB_SDK
/*
 * keyboard handler for local keys, only in SDK mode
*/
	int
_kbdHandler( KEY key )
{
	switch( key ){
		case KEY_LT:
		case KEY_RT:
		case KEY_UP:
		case KEY_DN:
		case KEY_HOME:
		case KEY_END:
		case KEY_INS:
		case KEY_DEL:
			_kbdPut( key, TRUE );
			return HANDLED;
	}
	return NOT_HANDLED;
}
#else /* #ifdef PB_SDK */

/*
 * use this function to set the value of external input, defaults to FALSE
 * this is for EXE only, PEXes have ExternalInput()
*/
	bool
__kbExternalInput( void )
{
	return FALSE;
}
#endif /* #ifdef PB_SDK */

/*
 * initializes the extended leyboard handler
*/
	void
kbInit( void )
{
	_kbdHead = _kbdTail = 0;
	InstallHandler( HANDLER_SYSOPKEY, _kbdHandler );
}

/*
 * deinitializes the keyboard handler
*/
	void
kbDeinit( void )
{
	RemoveHandler( HANDLER_SYSOPKEY, _kbdHandler );
}

/*
 * see if a key is available, return it w/o removing from the queue
*/
	int
kbPeekKey( bool *local )
{
	if( _kbdEmpty() ) return 0;
	if( local ) *local = _KeyBuf[_kbdHead].local;
	return _KeyBuf[_kbdHead].code;
}

/*
 * wait for key and return
*/
	int
kbGetKey( bool *local )
{
	__keyBuff key;

	_kbdWaitKey();
	_kbdGet( &key );
	if( local ) *local = key.local;
	return key.code;
}

/*
 * gets a key from the buffer (we know we have it)
*/
	void
_kbdGet( __keyBuff *key )
{
	key->local = _KeyBuf[_kbdHead].local;
	key->code  = _KeyBuf[_kbdHead].code;

	_kbdHead = (_kbdHead + 1) % MAX_KBDBUF;
}

/*
 * stuffs a key into the buffer
*/
	void
_kbdPut( int key, bool local )
{
	_KeyBuf[_kbdTail].local = local;
	_KeyBuf[_kbdTail].code  = key;

	_kbdTail = (_kbdTail + 1) % MAX_KBDBUF;
	if( _kbdTail == _kbdHead ) _kbdHead = (_kbdHead + 1) % MAX_KBDBUF;
}

/*
 * waits and translates keystrokes
*/
	void
_kbdWaitKey( void )
{
	int ch;

#ifdef PB_SDK
	/* wait for a key, local and remote */
	do{
		if( !_kbdEmpty() ) return; /* the handler stuffed something in */
		ch = PeekChar();
	}while( !ch );
#else
	int _ext = FALSE;

	ch = getch();
	if( !ch ){
		ch = getch();
		_ext = TRUE;
	}
#endif

	/*
	 * we have a key, if it was local, simply put in buffer and return
	*/
	if( !ExternalInput() ){
#ifndef PB_SDK
	if( _ext )
#endif
		switch(ch){
			case 77 : _kbdPut( KEY_RT, TRUE ); return;
			case 75 : _kbdPut( KEY_LT, TRUE ); return;
			case 72 : _kbdPut( KEY_UP, TRUE ); return;
			case 80 : _kbdPut( KEY_DN, TRUE ); return;
			case 71 : _kbdPut( KEY_HOME, TRUE ); return;
			case 79 : _kbdPut( KEY_END, TRUE ); return;
			case 82 : _kbdPut( KEY_INS, TRUE ); return;
			case 83 : _kbdPut( KEY_DEL, TRUE ); return;
		}
		_kbdPut( ch, TRUE );
		return;
	}

	/*
	 * if we don't have the ANSI escape sequence start, store key and bye
	*/
	if( ANSI_ESCAPE != ch ){
		_kbdPut( ch, FALSE );
		return;
	}

	/* wait for a key for 9 ticks, approx .5 sec */
	for( ch = 0, timer_start(); !ch && timer_diff() < 9; ch = PeekChar() )
		;

	/* no key in buffer, store the Escape and return */
	if( !ch ){
		_kbdPut( ANSI_ESCAPE, FALSE );
		return;
	}

	/* if not a '[', store the Escape, the new key and return */
	if( ANSI_SEQ != ch ){
		_kbdPut( ANSI_ESCAPE, FALSE );
		_kbdPut( ch, FALSE );
		return;
	}

	/* wait for a key for 9 ticks, approx .5 sec */
	for( ch = 0, timer_start(); !ch && timer_diff() < 9; ch = PeekChar() )
		;

	/* no key, store the Escape, the '[' and return */
	if( !ch ){
		_kbdPut( ANSI_ESCAPE, FALSE );
		_kbdPut( ANSI_SEQ, FALSE );
		return;
	}

	/* new key, decode the value and convert if necessary */
	switch( ch ){
		case 65 : _kbdPut( KEY_UP, FALSE );     break;
		case 66 : _kbdPut( KEY_DN, FALSE );     break;
		case 67 : _kbdPut( KEY_RT, FALSE );     break;
		case 68 : _kbdPut( KEY_LT, FALSE );     break;
		case 72 : _kbdPut( KEY_HOME, FALSE );   break;
		case 75 : _kbdPut( KEY_END, FALSE );    break;
		case 82 : _kbdPut( KEY_INS, FALSE );    break;
		case 83 : _kbdPut( KEY_DEL, FALSE );    break;
		default:
			/* not extended key, store Escape, '[' and the key and bye */
			_kbdPut( ANSI_ESCAPE, FALSE );
			_kbdPut( ANSI_SEQ, FALSE );
			_kbdPut( ch, FALSE );
	}
}

/*
 * flushes the keyboard buffer
*/
	void
kbFlush( void )
{
	_kbdHead = _kbdTail = 0;
}

#undef ANSI_ESCAPE
#undef ANSI_SEQ
#undef _kbdEmpty
#ifndef PB_SDK
#undef PeekChar
#undef ExternalInput
#endif
