/*
 * PB-Lib C/C++ Library Version 0.021
 *
 * Copyright (C) 1995 by Branislav L. Slantchev
 * A product of Silicon Creations, Inc.
 *
 * See the file "copying.pbl" for licensing information.
*/

#ifndef __PROUTIL_H
#include <proutil.h>
#endif

#ifndef __STDINI_H
#include <stdini.h>
#endif

#ifndef __FSYS_H
#include <fsys.h>
#endif

/*
 
  Offline versions of GetIniVar() and SetIniVar(): no section support
 
*/
#ifndef PB_SDK

/*
 * reads a variable from ProBoard-style INI file
*/
	bool
GetIniVar( char *fname, char *var, char *value, int len )
{
	char path[81], buf[MAX_INI_LINE];

	chext( path, fname, ".INI" );
	if( -1 == IniReadStr(path, NULL, var, buf, 0 ) ) return FALSE;
	sprintf( value, "%-*s", len, buf );
	return TRUE;
}

/*
 * writes a variable to ProBoard-style INI file.
*/
	bool
SetIniVar( char *fname, char *var, char *value )
{
	char path[81];

	chext( path, fname, ".INI" );
	if( -1 == IniWrite(path, NULL, var, value) ) return FALSE;
	return TRUE;
}
#endif /* #ifdef PB_SDK */
