/*
 * PB-Lib C/C++ Library Version 0.021
 *
 * Copyright (C) 1995 by Branislav L. Slantchev
 * A product of Silicon Creations, Inc.
 *
 * See the file "copying.pbl" for licensing information.
*/

#ifndef __PROUTIL_H
#include <proutil.h>
#endif
#ifndef __GREP_H
#include <grep.h>
#endif

#ifndef PB_SDK
#include <stdio.h>
#include <assert.h>
#include <string.h>
#endif

static FILE *__fpndx = NULL;     /* pointer to the current open file index */

/*
 * opens a file index and prepares it for searching
*/
	int
OpenFileIndex( void )
{
	if( __fpndx ) return -1;              /* already opened, not reentrant */

	if( NULL == (__fpndx = pbfopen(fnFILESIDX, "rb")) )
		return -1;
	setvbuf( __fpndx, NULL, _IOFBF, 0x4000 ); /* assign a large 16K buffer */
	return 0;
}


/*
 * closes the file index
*/
	int
CloseFileIndex( void )
{
	assert( __fpndx != NULL );
	return fclose( __fpndx );
}

/*
 * rewinds the file index
*/
	void
RewindFileIndex( void )
{
	assert( __fpndx != NULL );
	rewind( __fpndx );
}

/*
 * searches the file index, if mask is NULL continues from current position
 * otherwise, rewinds and starts from the beginning with the new mask
 * returns area where file was found and file that matched mask. uses glob()
*/
	int
SearchFileIndex( char *match, const char *mask )
{
	assert( __fpndx != NULL );

	/* if mask is not NULL, init a new search */
	if( mask ){
		rewind( __fpndx );
		if( -1 == glob_compile(mask) ) return -1;
	}

	/* read file definition from index and try to match it */
	do{
		FILESIDX fi;
		if( 1 != fread( &fi, sizeof(FILESIDX), 1, __fpndx ) ) return -1;
		if( feof(__fpndx) ) return -1;

		if( 0 == glob_match(fi.filename) ){
			strcpy( match, fi.filename );
			return (int)fi.area;
		}
	}while( 1 );
}


#ifdef FINDEX_DEBUG
#ifndef PB_SDK
#include <string.h>
#endif
	int
main( int argc, char *argv[] )
{
	char mask[BUFSIZ], match[BUFSIZ];

	if( --argc ){
		strcpy( mask, strupr(argv[1]) );
		OpenFileIndex();

		int area = SearchFileIndex( match, mask );
		while( -1 != area ){
			printf( "found '%s' in area %d\n", match, area );
			area = SearchFileIndex( match, NULL );
		}
		CloseFileIndex();
	}
	else printf( "usage: %s <file_mask>", strlwr(*argv) );
	return 0;
}

#endif
