/*
 * PB-Lib C/C++ Library Version 0.021
 *
 * Copyright (C) 1995 by Branislav L. Slantchev
 * A product of Silicon Creations, Inc.
 *
 * See the file "copying.pbl" for licensing information.
*/

#ifndef __PROUTIL_H
#include <proutil.h>
#endif

#ifndef __FSYS_H
#include <fsys.h>
#endif

#ifdef PB_SDK
	#define __systemPath SysPath
#else
	#include <stdlib.h>
	#include <string.h>
	#define __systemPath getenv("PROBOARD")
#endif

char *_mkUserPath( const char *filename );
char *_mkSysPath( const char *filename );

/*
 
  Public functions exported by this module.
 
*/

/*
 * opens a file in the system directory
*/
	FILE*
pbfopen( const char *filename, const char *mode )
{
	return fopen( _mkSysPath(filename), mode );
}

/*
 * opens a file in the userbase directory
*/
	FILE*
usrfopen( const char *filename, const char *mode )
{
	return fopen( _mkUserPath(filename), mode );
}


/*
 * creates a backup copy of a file in the userbase directory
*/
	int
UserBackup( const char *filename )
{
	char dest[MAXPATH], src[MAXPATH];

	strcpy( src, _mkUserPath(filename) );
	chext( dest, src, ".BAK" );
	return cpfile( dest, src );
}

/*
 * creates a path to a file in the system directory
*/
	char*
_mkSysPath( const char *filename )
{
	static char path[MAXPATH];

	sprintf( path, "%s\\%s", __systemPath, filename );
	return path;
}

/*
 * creates a path to a file in the userbase directory
*/
	char*
_mkUserPath( const char *filename )
{
	static char  path[MAXPATH];
	CONFIG       cfg;
	FILE        *fp = pbfopen( fnCONFIG, "rb" );
	int          stat;

	if( !fp ) return NULL;
	stat = fread(&cfg, sizeof(CONFIG), 1, fp);
	fclose( fp );
	if( 1 != stat ) return NULL;
	sprintf( path, "%s\\%s", cfg.msgpath, filename );
	return path;
}

/*
 * returns number of records of width in file filename
*/
	long
NumFileRecs( const char *filename, size_t width )
{
	FILE *fp = fopen( filename, "rb" );
	long  num = -1L;

	if( fp ){
		fseek( fp, 0L, SEEK_END );
		num = l_div( ftell(fp), (long)width );
		fclose(fp);
	}
	return num;
}

/*
 * writes a record of size width to the file as recNum, recNum starts
 * the numbering at 1. If recNum is too big, record is appended to the
 * end of the file. I/O is in binary.
*/
	int
WriteFileRec( const char *fname, long recNum, const void *rec, size_t width )
{
	FILE *fp = fopen( fname, "r+b" );
	long  ofs = l_mul( recNum - 1L, (long)width );
	int   retval = -1;

	if( fp ){
		fseek( fp, ofs, SEEK_SET );
		if( ofs != ftell(fp) ) fseek( fp, 0L, SEEK_END );
		if( 1 == fwrite(rec, width, 1, fp) ) retval = 0;
		fclose(fp);
	}
	return retval;
}

/*
 * reads a record from strucutred file. recNum starts the numbering from 1
*/
	int
ReadFileRec( const char *fname, long recNum, void *rec, size_t width )
{
	FILE *fp = fopen( fname, "rb" );
	long  ofs = l_mul( recNum - 1L, (long)width );
	int   retval = -1;

	if( fp ){
		fseek( fp, ofs, SEEK_SET );
		if( ofs == ftell(fp) && 1 == fread(rec, width, 1, fp) ) retval = 0;
		fclose(fp);
	}
	return retval;
}

#undef __systemPath

