/*
 * PB-Lib C/C++ Library Version 0.021
 *
 * Copyright (C) 1995 by Branislav L. Slantchev
 * A product of Silicon Creations, Inc.
 *
 * See the file "copying.pbl" for licensing information.
*/

#ifdef PB_SDK
#error You don't need this file: the SDK has those functions already!
#endif

#ifndef __PROUTIL_H
#include <proutil.h>
#endif

/*
 * return number of available file areas, -1 on error
*/
	int
NumFileAreas( void )
{
	return (int)NumFileRecs( _mkSysPath(fnFILECFG), sizeof(FILECFG) );
}

/*
 * reads a file area into structure, numbering starts at 1
*/
	int
ReadFileArea( int areaNum, FILEAREA *fa )
{
	return ReadFileRec( _mkSysPath(fnFILECFG), (long)areaNum,
						fa, sizeof(FILEAREA) );
}

/*
 * returns the number of available file groups
*/
	int
NumFileGroups( void )
{
	return (int)NumFileRecs( _mkSysPath(fnFGROUPS), sizeof(FILEGROUP) );
}

/*
 * reads a file group into structure (must be allocated prior to call)
 * group numbering starts at 1.
*/
	int
ReadFileGroup( int groupNum, FILEGROUP *fg )
{
	return ReadFileRec( _mkSysPath(fnFGROUPS), (long)groupNum,
						fg, sizeof(FILEGROUP) );
}
