/*
 * PB-Lib C/C++ Library Version 0.021
 *
 * Copyright (C) 1995 by Branislav L. Slantchev
 * A product of Silicon Creations, Inc.
 *
 * See the file "copying.pbl" for licensing information.
*/

#ifndef __FAIL_H
#include <fail.h>
#endif

#ifndef __PROUTIL_H
#include <proutil.h>
#endif

#ifndef PB_SDK
#include <stdio.h>
#include <stdarg.h>
#include <stdlib.h>
#include <time.h>
#endif

/*
 * logs to proboard's log file
*/
	void
pbfail( const char *fmt, ... )
{
	char    buf[20];
	va_list varg;

	FILE *fp = pbfopen( "PROBOARD.LOG", "at" );
	if( fp ){
		time_t tmr = time( NULL );
		strftime( buf, 19, "%d-%b-%y %H:%M:%S", localtime( &tmr ) );
		fprintf( fp, "%s ", buf );
		va_start( varg, fmt );
		vfprintf( fp, fmt, varg );
		fputc( '\n', fp );
		fclose( fp );
	}
	va_start( varg, fmt );
	vprintf( fmt, varg );
	va_end( varg );
	exit( EXIT_FAILURE );
}
