/*
 * PB-Lib C/C++ Library Version 0.021
 *
 * Copyright (C) 1995 by Branislav L. Slantchev
 * A product of Silicon Creations, Inc.
 *
 * See the file "copying.pbl" for licensing information.
*/

#ifndef __PROUTIL_H
#include <proutil.h>
#endif

#ifndef PB_SDK
#include <stdlib.h>
#include <string.h>
#endif

/*
 * conversion characters
*/
static const char __b36toa[36] = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";

/*
 * convert a long into a MegaNum (base-36)
*/
	char*
ltom( long value )
{
	static char buf[8]; /* the maximum length is 7 */
	char *p = buf;
	int v;

	do{
		v = (int)ul_mod( value, 36L );
		*p++ = __b36toa[v];
		value = ul_div( value, 36L );
	}while( value >= 36 );

	if( value ) *p++ = __b36toa[(int)value];
	*p = EOS;
	return strrev( buf );
}

/*
 * converts a MegaNum into a long
*/
	long
mtol( const char *s )
{
	dword mul = 1;
	long val;
	int  num, len = strlen(s) - 1;

	for( val = 0L; len >= 0; --len ){
		if( s[len] < '9' ) num = s[len] - '0';
		else num = s[len] - '7';
		val += (dword)l_mul( (long)num, mul );
		mul = l_mul( mul, 36 );
	}

	return val;
}
