/*
 * PB-Lib C/C++ Library Version 0.021
 *
 * Copyright (C) 1995 by Branislav L. Slantchev
 * A product of Silicon Creations, Inc.
 *
 * See the file "copying.pbl" for licensing information.
*/

#ifndef __PROUTIL_H
#include <proutil.h>
#endif

/*
 * duplicates the SDK's Input() function for offline usage.
*/
#ifndef PB_SDK
#include <conio.h>
#include <ctype.h>

	void
Input( char *buf, int len, int mode )
{
    int   ch;
    int   i;

	if( !(mode & INPUT_NOFIELD) ){
		textbackground( 0x01 );
		for( ch = 0; ch <= len; ++ch ) putch( ' ' );
		for( ; ch > 0; --ch ) putch( '\b' );
	}

	for( i = 0;; ){
		ch = getch();

		if( '\r' == ch ){ buf[i] = EOS; return; }
		if( '\b' == ch ){
			if( 0 < i ){ --i; cprintf( "\b \b" ); }
			continue;
		}
		if( len == i ) continue;

		if( (mode & 0x0f) == INPUT_UPALL ) ch = toupper(ch);
		else if( ((mode & 0x0f) == INPUT_DIGITS) && !isdigit(ch) ) continue;
		else if( (mode & 0x0f) == INPUT_UPFIRST ){
			if( !i || isspace(buf[i - 1]) ) ch = toupper(ch);
		}

		if( mode & INPUT_PWD ) putch( '*' );
		else putch( ch );
		buf[i++] = ch;
	}
}
#endif
