/*
 * PB-Lib C/C++ Library Version 0.021
 *
 * Copyright (C) 1995 by Branislav L. Slantchev
 * A product of Silicon Creations, Inc.
 *
 * See the file "copying.pbl" for licensing information.
*/

#ifndef __PROUTIL_H
#include <proutil.h>
#endif

#ifdef __BOARD_NOMAC
#ifndef PB_SDK
#include <string.h>
#endif

	bool
GetBoard( int num, combinedboards boards )
{
	return BOOL( boards[num >> 3] & (1 << (num & 0x07)) );
}

	void
SetBoard( int num, combinedboards boards )
{
	boards[num >> 3] |= 1 << (num & 0x07);
}

	void
ToggleBoard( int num, combinedboards boards )
{
	boards[num >> 3] ^= 1 << (num & 0x07);
}

	void
UnsetBoard( int num, combinedboards boards )
{
	boards[num >> 3] &= ~(1 << (num & 0x07));
}

	void
UnsetAllBoards( combinedboards boards )
{
	memset( boards, 0, sizeof(combinedboards) );
}

	void
SetAllBoards( combinedboards boards )
{
	memset( boards, 1, sizeof(combinedboards) );
}

#endif
