/*
 * PB-Lib C/C++ Library Version 0.021
 *
 * Copyright (C) 1995 by Branislav L. Slantchev
 * A product of Silicon Creations, Inc.
 *
 * See the file "copying.pbl" for licensing information.
*/

#ifndef __TIMER_H
#include <timer.h>
#endif

static dword _timerStart;  /* start value of timer while running */
static dword _timerStop;   /* end value of timer when stopped    */
	   bool  _timerIdle;   /* TRUE is timer is not running       */

/*
 * Create a far pointer to MS-DOS system area to read the clock
*/
#define __TIMER *(dword far *)0x46c

/*
 * Starts the timer.
*/
	void
timer_start( void )
{
	_timerIdle = FALSE;
	_timerStart = __TIMER;
}

/*
 * Stops the timer.
*/
	void
timer_stop( void )
{
	_timerIdle = TRUE;
	_timerStop = __TIMER;
}

/*
 * Returns elapsed ticks (does not stop the timer)
*/
	dword
timer_diff( void )
{
	if( FALSE == _timerIdle )
		_timerStop = __TIMER;

	return _timerStop - _timerStart;
}

/*
 * Suspends program execution for wait number of ticks
*/
	void
timer_sleep( dword wait )
{
	timer_start();

	while( wait > timer_diff() )
		;
}

#undef __TIMER
