/*
 * PB-Lib C/C++ Library Version 0.021
 *
 * Copyright (C) 1995 by Branislav L. Slantchev
 * A product of Silicon Creations, Inc.
 *
 * See the file "copying.pbl" for licensing information.
*/

#ifndef __SORT_H
#include <sort.h>
#endif

static    FCMP  _comp;
static  size_t  _eWidth;
static  char   *_base;

static void _quickerSort( size_t left, size_t right );

/*
 * wrapper for the real Quicker Sort function
*/
	void
qsort( void *base, size_t nelem, size_t width, FCMP fcmp )
{
	if( 0 == (_eWidth = width) ) return;
	_comp = fcmp;
	_base = (char *)base;

	_quickerSort( 0, nelem - 1 );
}

/*
 * the real Quicker Sort function (algorithm by Hoare)
*/
	void
_quickerSort( size_t left, size_t right )
{
	int  i, j;
	char *pivot, *pRight, *pLeft, *p1, *p2;

	/* determine the pivot element and setup variables */
	pivot  = _base + (_eWidth * ((left + right) / 2));
	pLeft  = _base + (_eWidth * left);
	pRight = _base + (_eWidth * right);

	/*
	 * move all elements smaller than the pivot to its left and all
	 * larger than it, to the right.
	*/
	do{
		/* find element larger than pivot to left of the pivot */
		while( _comp(pLeft, pivot) < 0 && pLeft < pRight )
			pLeft += _eWidth;
		/* find element smaller than pivot to the right of the pivot */
		while( _comp(pRight, pivot) > 0 && pRight > pLeft )
			pRight -= _eWidth;

		/* exchange the two elements */
		if( pLeft <= pRight ){
			p1 = pRight; p2 = pLeft;
			for( i = 0; i < _eWidth; ++i ){
				char t = *p1;
				*p1++ = *p2;
				*p2++ = t;
			}
		}

		pLeft += _eWidth; pRight -= _eWidth;
	}while( pLeft <= pRight );

	/* sort the left and right partitions */
	j = (int)((pRight - _base) / _eWidth);
	i = (int)((pLeft - _base) / _eWidth);
	if( left < j )  _quickerSort( left, j );
	if( i < right ) _quickerSort( i, right );
}
