/*
 * PB-Lib C/C++ Library Version 0.021
 *
 * Copyright (C) 1995 by Branislav L. Slantchev
 * A product of Silicon Creations, Inc.
 *
 * See the file "copying.pbl" for licensing information.
*/

#ifndef __FAIL_H
#include <fail.h>
#endif

#ifndef PB_SDK
#include <stdio.h>
#include <stdarg.h>
#include <stdlib.h>
#endif

/*
 * general fail: displays text and exits
*/
	void
fail( const char *fmt, ... )
{
	va_list varg;

	va_start( varg, fmt );
	vprintf( fmt, varg );
	va_end( varg );
	exit( EXIT_FAILURE );
}

/*
 * fail that logs to a file (you need to give the necessary C/R and L/F)
*/
	void
ffail( const char *logfile, const char *fmt, ... )
{
	va_list varg;

	FILE *fp = fopen( logfile, "at" );
	if( fp ){
		va_start( varg, fmt );
		vfprintf( fp, fmt, varg );
		fclose( fp );
	}
	va_start( varg, fmt );
	vprintf( fmt, varg );
	va_end( varg );
	exit( EXIT_FAILURE );
}

