/*
 * PB-Lib C/C++ Library Version 0.021
 *
 * Copyright (C) 1995 by Branislav L. Slantchev
 * A product of Silicon Creations, Inc.
 *
 * See the file "copying.pbl" for licensing information.
*/

#ifndef __DATE_H
#include <date.h>
#endif

#ifndef PB_SDK
#include <assert.h>
#endif

/*
 * returns 0 if year is not leap and 1 otherwise
*/
	bool
date_isleap( int year )
{
	return BOOL( !(year % 4) && ((year % 100) || !(year % 400)) );
}

/*
 * converts date to julian format
*/
	int
date_julian( int day, int mon, int year )
{
	static int mdays[12] = { 0, 31, 59, 90, 120, 151, 181,
							 212, 243, 273, 304, 334 };
	int julian;

	assert( 1 <= day && 31 >= day );
	assert( 1 <= mon && 12 >= mon );
	assert( 0 < year );

	julian = mdays[mon - 1] + day;
	if( 2 < mon ) julian += date_isleap( year );
	return julian;
}


/*
 * returns difference (in days) between two dates,
 * result is > 0, means that y2 is more recent than y1
 * result is < 0, means that y1 is more recent than y2
*/
	long
date_diff( int d1, int m1, int y1, int d2, int m2, int y2 )
{
	long days;
	int  mult = 1;
	int  j1 = date_julian( d1, m1, y1 );
	int  j2 = date_julian( d2, m2, y2 );

	/* same year, return difference */
	if( y1 == y2 ) return j2 - j1;

	if( y1 > y2 ){
		days = (long)j1 + date_julian( 31, 12, y2 ) - j2;
		SWAP( y1, y2, int );
		mult = -1;
	}
	else days = (long)j2 + date_julian( 31, 12, y1 ) - j1;

	/* adjust for years in between */
	for( y1++; y1 < y2; ++y1 )
		days += (long)365 + date_isleap( y1 );

	return l_mul(days, (long)mult);
}

