/*
 * PB-Lib C/C++ Library Version 0.021
 *
 * Copyright (C) 1995 by Branislav L. Slantchev
 * A product of Silicon Creations, Inc.
 *
 * See the file "copying.pbl" for licensing information.
*/

#ifndef __SORT_H
#include <sort.h>
#endif

/*
 * binary search routine
*/
	void*
bsearch(const void *key, const void *base, size_t nelem,
		size_t width, int (*fcmp)(const void*, const void*) )
{
	size_t i;
	int    j;
	char   *celem, *cbase = (char *)base;

	while( nelem ){
		i = nelem >> 1;                 /* get the middle element       */
		celem = cbase + i * width;      /* calculate offset into array  */
		j = fcmp( key, celem );
		if( 0 == j ) return celem;
		if( 0 > j ) nelem = i;          /* smaller, set new end         */
		else{
			cbase = celem + width;      /* larger, set new beginning to */
			nelem = nelem - i - 1;      /* next element and adjust num  */
		}                               /* of entries to process        */
	}
	return 0;
}

