/*
 * PB-Lib C/C++ Library Version 0.021
 *
 * Copyright (C) 1995 by Branislav L. Slantchev
 * A product of Silicon Creations, Inc.
 *
 * See the file "copying.pbl" for licensing information.
*/

#ifndef __FSYS_H
#include <fsys.h>
#endif

#ifndef PB_SDK
#include <string.h>
#include <stdlib.h>
#include <time.h>
#include <io.h>
#endif

static char *_genUnique( char *path );

/*
** creates a temp filename, returns name doesn't create file
*/
	char*
tempname( void )
{
	static char path[81];
	char *ptr;

	ptr = getenv( "TEMP" );
	if( !ptr ) ptr = getenv( "TMP" );
	if( !ptr ) strcpy( path, ".\\" );
	else strcat( strcpy(path, ptr), "\\" );

	return _genUnique( path );
}

/*
** creates a temp filename in specified '\\'-terminated directory.
*/
	char*
tmpname( char *path )
{
	return _genUnique( path );
}


/*
** generates a unique name, appends to path argument (must be '\\' term.)
*/
	static char*
_genUnique( char *path )
{
	char *ends;
	int   retry;

	ends = &path[strlen(path)];

	for( retry = 0; retry < 200; retry++ ){
		*ends = '\0';
		sprintf( ends, "%lX", (unsigned long)time(NULL) + retry );
		if( -1 == access( path, 0 ) ){
			FILE *fp = fopen( path, "w+" );
			if( !fp ) return NULL;
			fclose( fp );
			unlink( path );
			return path;
		}
	}
	return NULL;
}
