/*
 * PB-Lib C/C++ Library Version 0.021
 *
 * Copyright (C) 1995 by Branislav L. Slantchev
 * A product of Silicon Creations, Inc.
 *
 * See the file "copying.pbl" for licensing information.
*/

#ifndef __FSYS_H
#include <fsys.h>
#endif

#ifndef PB_SDK
#include <dos.h>
#undef tell
#endif

#if defined( PB_SDK ) || defined( __ZTC__ )
/*
** tell: same as standard C library tell(), works for the SDK and Zortech
*/
   long
tell( int handle )
{
	union REGS r;

	r.h.ah = 0x42;
	r.x.bx = handle;
	r.x.cx = r.x.dx = 0;
	r.h.al = 1;  /* move from current position */
	int86( 0x21, &r, &r );
	if( r.x.cflag ) return -1L;
	return l_shr(r.x.dx, 16) + r.x.ax;
}
#else /* for Turbo/Borland and Microsoft C, use the io.h tell() */
	/* MSC chokes w/o this. Why? */
#endif
