/*
 * PB-Lib C/C++ Library Version 0.021
 *
 * Copyright (C) 1995 by Branislav L. Slantchev
 * A product of Silicon Creations, Inc.
 *
 * See the file "copying.pbl" for licensing information.
*/

#ifndef __FSYS_H
#include <fsys.h>
#endif

#ifndef PB_SDK
#include <direct.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <io.h>
#endif

/*
 * searches the path variable for a file given in filename. if path is
 * NULL, searches the current directory and then the system PATH statement.
 * You can separate multiple directories in the path string with the MS-DOS
 * style ';' separator. On success, a full filespec is returned, null
 * otherwise.
 *
 * The return string is static and is overwritten with each call.
*/
	char*
searchPath( char *pathList, const char *filename )
{
	static char  path[MAXPATH];
		   char  name[MAXFILE+MAXEXT];
		   char *ptr;

	/* do some sanity checking and prepend a backslash */
	assert( strlen(filename) < (MAXFILE + MAXEXT) );
	strcat( strcpy(name, "\\"), filename );

	/* check current directory and get PATH (if necessary) */
	if( NULL == pathList ){
		assert(NULL != getcwd(path, MAXDIR));
		strcat( path, name );
		if( 0 == access(path, 0) ) return path;
		assert(NULL != (pathList = getenv("PATH")) );
	}

	/* we know we have something in our pathList pointer now */
	ptr = strtok( pathList, ";" );
	while( NULL != ptr ){
		strcat( strcpy(path, ptr), name );
		if( 0 == access(path, 0) ) return path;
		ptr = strtok( NULL, ";" );
	}

	/* nada, zilch, failed miserably, sorry... */
	return NULL;
}

